/*
 * Decompiled with CFR 0.152.
 */
package io.realm.analytics;

import io.realm.analytics.AnalyticsData;
import io.realm.analytics.PublicAppId;
import io.realm.analytics.RealmAnalyticsKt;
import io.realm.analytics.UrlEncodedAnalytics;
import io.realm.transformer.RealmTransformerKt;
import io.realm.transformer.Utils;
import io.realm.transformer.ext.ProjectExtKt;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/realm/analytics/RealmAnalytics;", "", "()V", "data", "Lio/realm/analytics/AnalyticsData;", "calculateAnalyticsData", "", "project", "Lorg/gradle/api/Project;", "execute", "", "isAnalyticsEnabled", "realm-transformer"})
public final class RealmAnalytics {
    @Nullable
    private AnalyticsData data;

    public final void execute() {
        try {
            AnalyticsData analyticsData = this.data;
            if (analyticsData == null) {
                return;
            }
            AnalyticsData analyticsData2 = analyticsData;
            ExecutorService pool = Executors.newFixedThreadPool(1);
            try {
                pool.execute(() -> RealmAnalytics.execute$lambda-0(analyticsData2));
                pool.awaitTermination(RealmTransformerKt.getCONNECT_TIMEOUT() + RealmTransformerKt.getREAD_TIMEOUT(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                pool.shutdownNow();
            }
        }
        catch (Exception e) {
            RealmAnalyticsKt.getLogger().debug(Intrinsics.stringPlus((String)"Error happened when sending Realm analytics data: ", (Object)e));
        }
    }

    public final boolean calculateAnalyticsData(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.isAnalyticsEnabled(project)) {
            return false;
        }
        boolean containsKotlin = false;
        block2: for (Configuration conf : project.getConfigurations()) {
            try {
                for (Object object : conf.getResolvedConfiguration().getResolvedArtifacts()) {
                    Intrinsics.checkNotNullExpressionValue(object, (String)"conf.resolvedConfiguration.resolvedArtifacts");
                    ResolvedArtifact artifact = (ResolvedArtifact)object;
                    object = artifact.getName();
                    Intrinsics.checkNotNullExpressionValue(object, (String)"artifact.name");
                    if (!StringsKt.startsWith$default(object, (String)"kotlin-stdlib", (boolean)false, (int)2, null)) continue;
                    containsKotlin = true;
                    break block2;
                }
            }
            catch (Exception exception) {
            }
        }
        String appId = ProjectExtKt.getAppId(project);
        String targetSdk = ProjectExtKt.getTargetSdk(project);
        String minSdk = ProjectExtKt.getMinSdk(project);
        String target = project.getPlugins().findPlugin("com.android.application") != null ? "app" : (project.getPlugins().findPlugin("com.android.library") != null ? "library" : "unknown");
        String gradleVersion = project.getGradle().getGradleVersion();
        String agpVersion = ProjectExtKt.getAgpVersion(project);
        boolean sync = Utils.isSyncEnabled(project);
        String string = PublicAppId.constructor-impl(appId);
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"gradleVersion");
        this.data = new AnalyticsData(string, containsKotlin, sync, targetSdk, minSdk, target, gradleVersion, agpVersion, null);
        return true;
    }

    private final boolean isAnalyticsEnabled(Project project) {
        Map<String, String> env = System.getenv();
        return !project.getGradle().getStartParameter().isOffline() && env.get("REALM_DISABLE_ANALYTICS") == null && env.get("CI") == null;
    }

    private static final void execute$lambda-0(AnalyticsData $analyticsData) {
        Intrinsics.checkNotNullParameter((Object)$analyticsData, (String)"$analyticsData");
        UrlEncodedAnalytics.Companion.create().execute($analyticsData);
    }
}

