/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer.build;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import io.realm.annotations.RealmClass;
import io.realm.transformer.BytecodeModifier;
import io.realm.transformer.ProjectMetaData;
import io.realm.transformer.RealmTransformer;
import io.realm.transformer.RealmTransformerKt;
import io.realm.transformer.build.BuildTemplate;
import io.realm.transformer.ext.CtClassExtKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.CtClass;
import javassist.NotFoundException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ2\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J$\u0010\u0012\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0014J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0014J\u0016\u0010\u0019\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016\u00a8\u0006\u001c"}, d2={"Lio/realm/transformer/build/IncrementalBuild;", "Lio/realm/transformer/build/BuildTemplate;", "metadata", "Lio/realm/transformer/ProjectMetaData;", "outputProvider", "Lcom/android/build/api/transform/TransformOutputProvider;", "transform", "Lio/realm/transformer/RealmTransformer;", "(Lio/realm/transformer/ProjectMetaData;Lcom/android/build/api/transform/TransformOutputProvider;Lio/realm/transformer/RealmTransformer;)V", "categorizeClassNames", "", "inputs", "", "Lcom/android/build/api/transform/TransformInput;", "directoryFiles", "", "", "jarFiles", "filterForModelClasses", "outputClassNames", "", "outputReferencedClassNames", "findModelClasses", "Ljavassist/CtClass;", "classNames", "prepareOutputClasses", "", "transformDirectAccessToModelFields", "realm-transformer"})
public final class IncrementalBuild
extends BuildTemplate {
    public IncrementalBuild(@NotNull ProjectMetaData metadata, @NotNull TransformOutputProvider outputProvider, @NotNull RealmTransformer transform) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)outputProvider, (String)"outputProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)transform), (String)"transform");
        super(metadata, outputProvider, transform);
    }

    @Override
    public void prepareOutputClasses(@NotNull Collection<TransformInput> inputs) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        this.setInputs(inputs);
        this.categorizeClassNames(inputs, this.getOutputClassNames(), this.getOutputReferencedClassNames());
        RealmTransformerKt.getLogger().debug("Incremental build. Files being processed: " + this.getOutputClassNames().size() + '.');
        RealmTransformerKt.getLogger().debug(Intrinsics.stringPlus((String)"Incremental files: ", (Object)CollectionsKt.joinToString$default((Iterable)this.getOutputClassNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
    }

    @Override
    protected void filterForModelClasses(@NotNull Set<String> outputClassNames, @NotNull Set<String> outputReferencedClassNames) {
        Intrinsics.checkNotNullParameter(outputClassNames, (String)"outputClassNames");
        Intrinsics.checkNotNullParameter(outputReferencedClassNames, (String)"outputReferencedClassNames");
        this.getOutputModelClasses().addAll(this.findModelClasses(outputClassNames));
    }

    @Override
    public void transformDirectAccessToModelFields() {
        Iterable $this$forEach$iv = this.getOutputClassNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            RealmTransformerKt.getLogger().debug(Intrinsics.stringPlus((String)"Modify accessors in class: ", (Object)it));
            CtClass ctClass = this.getClassPool().getCtClass(it);
            Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"classPool.getCtClass(it)");
            CtClass ctClass2 = ctClass;
            BytecodeModifier.Companion.useRealmAccessors(this.getClassPool(), ctClass2, null);
            ctClass2.writeFile(this.getOutputFile(this.getOutputProvider(), Format.DIRECTORY).getCanonicalPath());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void categorizeClassNames(@NotNull Collection<? extends TransformInput> inputs, @NotNull Set<String> directoryFiles, @NotNull Set<String> jarFiles) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(directoryFiles, (String)"directoryFiles");
        Intrinsics.checkNotNullParameter(jarFiles, (String)"jarFiles");
        $this$forEach$iv = inputs;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (TransformInput)element$iv;
            $i$a$-forEach-IncrementalBuild$categorizeClassNames$1 = false;
            var10_10 = it.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)var10_10, (String)"it.directoryInputs");
            $this$forEach$iv = var10_10;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (DirectoryInput)element$iv;
                $i$a$-forEach-IncrementalBuild$categorizeClassNames$1$1 = false;
                var16_16 = it.getFile().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)var16_16, (String)"it.file.absolutePath");
                dirPath = var16_16;
                $this$forEach$iv = it.getChangedFiles().entrySet();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (Map.Entry)element$iv;
                    $i$a$-forEach-IncrementalBuild$categorizeClassNames$1$1$1 = false;
                    if (it.getValue() == Status.NOTCHANGED || it.getValue() == Status.REMOVED) continue;
                    var23_27 = ((File)it.getKey()).getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)var23_27, (String)"it.key.absolutePath");
                    filePath = var23_27;
                    if (!StringsKt.endsWith$default((String)filePath, (String)".class", (boolean)false, (int)2, null)) continue;
                    var25_29 = filePath;
                    var26_32 = dirPath.length() + 1;
                    var27_35 = filePath.length() - ".class".length();
                    var28_36 = false;
                    v0 = var25_29.substring(var26_32, var27_35);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    className = StringsKt.replace$default((String)v0, (char)File.separatorChar, (char)'.', (boolean)false, (int)4, null);
                    directoryFiles.add(className);
                }
            }
            $this$forEach$iv = it.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"it.jarInputs");
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (JarInput)element$iv;
                $i$a$-forEach-IncrementalBuild$categorizeClassNames$1$2 = false;
                if (it.getStatus() == Status.REMOVED) continue;
                jarFile = new JarFile(it.getFile());
                dirPath = jarFile.entries();
                Intrinsics.checkNotNullExpressionValue((Object)dirPath, (String)"jarFile.entries()");
                $i$f$forEach = false;
                v1 = Collections.list(dirPath);
                Intrinsics.checkNotNullExpressionValue(v1, (String)"java.util.Collections.list(this)");
                dirPath = v1;
                $i$f$filter = false;
                var19_19 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (JarEntry)element$iv$iv;
                    $i$a$-filter-IncrementalBuild$categorizeClassNames$1$2$1 = false;
                    if (it.isDirectory()) ** GOTO lbl-1000
                    var26_33 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)var26_33, (String)"it.name");
                    if (StringsKt.endsWith$default((String)var26_33, (String)".class", (boolean)false, (int)2, null)) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (JarEntry)element$iv;
                    $i$a$-forEach-IncrementalBuild$categorizeClassNames$1$2$2 = false;
                    element$iv$iv = it.getName();
                    Intrinsics.checkNotNullExpressionValue(element$iv$iv, (String)"it.name");
                    var25_31 = path = element$iv$iv;
                    var26_34 = 0;
                    var27_35 = path.length() - ".class".length();
                    var28_36 = false;
                    v3 = var25_31.substring(var26_34, var27_35);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    className = StringsKt.replace$default((String)StringsKt.replace$default((String)v3, (char)'/', (char)'.', (boolean)false, (int)4, null), (char)'\\', (char)'.', (boolean)false, (int)4, null);
                    jarFiles.add(className);
                }
                jarFile.close();
            }
        }
    }

    @Override
    @NotNull
    protected Collection<CtClass> findModelClasses(@NotNull Set<String> classNames) {
        Iterable $this$filterTo$iv$iv;
        CtClass it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(classNames, (String)"classNames");
        CtClass ctClass = this.getClassPool().get("io.realm.internal.RealmObjectProxy");
        Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"classPool.get(\"io.realm.\u2026ternal.RealmObjectProxy\")");
        CtClass realmObjectProxyInterface = ctClass;
        Iterable $this$map$iv = classNames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CtClass ctClass2 = this.getClassPool().getCtClass((String)it);
            collection.add(ctClass2);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CtClass)element$iv$iv;
            boolean bl = false;
            boolean result = false;
            if (it.hasAnnotation(RealmClass.class)) {
                result = true;
            } else {
                try {
                    CtClass ctClass3 = it.getSuperclass();
                    result = ctClass3 == null ? false : ctClass3.hasAnnotation(RealmClass.class);
                }
                catch (NotFoundException e) {
                    result = false;
                }
            }
            if (!result) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CtClass)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!(!CtClassExtKt.safeSubtypeOf(it, realmObjectProxyInterface))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CtClass)element$iv$iv;
            boolean bl = false;
            if (!(!it.getName().equals("io.realm.RealmObject"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

