/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer;

import com.android.build.api.artifact.ScopedArtifact;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.Component;
import com.android.build.api.variant.ScopedArtifacts;
import com.android.build.api.variant.Variant;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import io.realm.analytics.RealmAnalytics;
import io.realm.transformer.ModifyClassesTask;
import io.realm.transformer.ProjectMetaData;
import io.realm.transformer.RealmTransformer;
import io.realm.transformer.RealmTransformerKt;
import io.realm.transformer.Stopwatch;
import io.realm.transformer.Utils;
import io.realm.transformer.build.BuildTemplate;
import io.realm.transformer.build.FullBuild;
import io.realm.transformer.ext.ProjectExtKt;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.util.jar.JarOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\r\u0010\u0014\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0015R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/realm/transformer/RealmTransformer;", "", "metadata", "Lio/realm/transformer/ProjectMetaData;", "inputs", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/Directory;", "allJars", "Lorg/gradle/api/file/RegularFile;", "referencedInputs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "(Lio/realm/transformer/ProjectMetaData;Lorg/gradle/api/provider/ListProperty;Lorg/gradle/api/provider/ListProperty;Lorg/gradle/api/file/ConfigurableFileCollection;Lorg/gradle/api/file/RegularFileProperty;)V", "analytics", "Lio/realm/analytics/RealmAnalytics;", "exitTransform", "", "timer", "Lio/realm/transformer/Stopwatch;", "transform", "transform$realm_transformer", "Companion", "realm-transformer"})
public final class RealmTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectMetaData metadata;
    @NotNull
    private final ListProperty<Directory> inputs;
    @NotNull
    private final ListProperty<RegularFile> allJars;
    @NotNull
    private final ConfigurableFileCollection referencedInputs;
    @NotNull
    private final RegularFileProperty output;
    @Nullable
    private final RealmAnalytics analytics;

    /*
     * WARNING - void declaration
     */
    public RealmTransformer(@NotNull ProjectMetaData metadata, @NotNull ListProperty<Directory> inputs, @NotNull ListProperty<RegularFile> allJars, @NotNull ConfigurableFileCollection referencedInputs, @NotNull RegularFileProperty output) {
        RealmAnalytics realmAnalytics;
        RealmTransformer realmTransformer;
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter(allJars, (String)"allJars");
        Intrinsics.checkNotNullParameter((Object)referencedInputs, (String)"referencedInputs");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.metadata = metadata;
        this.inputs = inputs;
        this.allJars = allJars;
        this.referencedInputs = referencedInputs;
        this.output = output;
        RealmTransformer realmTransformer2 = this;
        try {
            realmTransformer = realmTransformer2;
            RealmAnalytics analytics = new RealmAnalytics();
            analytics.calculateAnalyticsData(this.metadata);
            realmAnalytics = analytics;
        }
        catch (Exception exception) {
            void e;
            realmTransformer = realmTransformer2;
            RealmTransformerKt.getLogger().debug("Could not calculate Realm analytics data:\n" + (Exception)e);
            realmAnalytics = null;
        }
        realmTransformer.analytics = realmAnalytics;
    }

    public final void transform$realm_transformer() {
        Stopwatch timer = new Stopwatch();
        timer.start("Realm Transform time");
        JarOutputStream jarOutput = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(((RegularFile)this.output.get()).getAsFile())));
        BuildTemplate build = new FullBuild(this.metadata, this.allJars, jarOutput, this);
        build.prepareOutputClasses(this.inputs);
        Stopwatch.splitTime$default(timer, "Prepare output classes", false, 2, null);
        if (build.hasNoOutput()) {
            this.exitTransform(timer);
            return;
        }
        build.prepareReferencedClasses(this.referencedInputs);
        Stopwatch.splitTime$default(timer, "Prepare referenced classes", false, 2, null);
        build.markMediatorsAsTransformed();
        Stopwatch.splitTime$default(timer, "Mark mediators as transformed", false, 2, null);
        build.transformModelClasses();
        Stopwatch.splitTime$default(timer, "Transform model classes", false, 2, null);
        build.transformDirectAccessToModelFields();
        Stopwatch.splitTime$default(timer, "Transform references to model fields", false, 2, null);
        build.copyProcessedClasses();
        Stopwatch.splitTime$default(timer, "Copy processed classes", false, 2, null);
        build.copyResourceFiles();
        Stopwatch.splitTime$default(timer, "Copy jar files", false, 2, null);
        jarOutput.close();
        this.exitTransform(timer);
    }

    private final void exitTransform(Stopwatch timer) {
        block0: {
            timer.stop();
            RealmAnalytics realmAnalytics = this.analytics;
            if (realmAnalytics == null) break block0;
            realmAnalytics.execute();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\u0006H\u0002J\f\u0010\t\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lio/realm/transformer/RealmTransformer$Companion;", "", "()V", "register", "", "project", "Lorg/gradle/api/Project;", "targetType", "", "usesKotlin", "", "realm-transformer"})
    public static final class Companion {
        private Companion() {
        }

        public final void register(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AndroidComponentsExtension androidComponents = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)androidComponents, (String)"androidComponents");
            AndroidComponentsExtension.onVariants$default((AndroidComponentsExtension)androidComponents, null, (Function1)((Function1)new Function1<Variant, Unit>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull Variant variant) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                    Iterable iterable = variant.getComponents();
                    Project project = this.$project;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Component component = (Component)element$iv;
                        boolean bl = false;
                        TaskProvider taskProvider = project.getTasks().register(component.getName() + "RealmAccessorsTransformer", ModifyClassesTask.class, arg_0 -> register.1.invoke$lambda-2$lambda-1(component, project, arg_0));
                        ScopedArtifacts scopedArtifacts = component.getArtifacts().forScope(ScopedArtifacts.Scope.PROJECT);
                        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"taskProvider");
                        scopedArtifacts.use(taskProvider).toTransform((ScopedArtifact)ScopedArtifact.CLASSES.INSTANCE, (Function1)register.1.1.INSTANCE, (Function1)register.1.2.INSTANCE, (Function1)register.1.3.INSTANCE);
                    }
                }

                private static final void invoke$lambda-2$lambda-1$lambda-0(ArtifactView.ViewConfiguration c) {
                    c.getAttributes().attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.CLASSES_JAR.getType());
                }

                private static final void invoke$lambda-2$lambda-1(Component $component, Project $project, ModifyClassesTask it) {
                    Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
                    Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                    it.getFullRuntimeClasspath().setFrom((Iterable)$component.getRuntimeConfiguration().getIncoming().artifactView(register.1::invoke$lambda-2$lambda-1$lambda-0).getFiles());
                    it.getBootClasspath().setFrom((Iterable)ProjectExtKt.getBootClasspath($project));
                    it.getOffline().set((Object)$project.getGradle().getStartParameter().isOffline());
                    it.getTargetType().set((Object)io.realm.transformer.RealmTransformer$Companion.access$targetType(RealmTransformer.Companion, $project));
                    it.getUsesKotlin().set((Object)io.realm.transformer.RealmTransformer$Companion.access$usesKotlin(RealmTransformer.Companion, $project));
                    it.getMinSdk().set((Object)ProjectExtKt.getMinSdk($project));
                    it.getTargetSdk().set((Object)ProjectExtKt.getTargetSdk($project));
                    it.getAgpVersion().set((Object)ProjectExtKt.getAgpVersion($project));
                    it.getUsesSync().set((Object)Utils.isSyncEnabled($project));
                    it.getGradleVersion().set((Object)$project.getGradle().getGradleVersion());
                    it.getAppId().set((Object)ProjectExtKt.getAppId($project));
                }
            }), (int)1, null);
        }

        private final String targetType(Project $this$targetType) {
            PluginContainer $this$targetType_u24lambda_u2d0 = $this$targetType.getProject().getPlugins();
            boolean bl = false;
            return $this$targetType_u24lambda_u2d0.findPlugin("com.android.application") != null ? "app" : ($this$targetType_u24lambda_u2d0.findPlugin("com.android.library") != null ? "library" : "unknown");
        }

        private final boolean usesKotlin(Project $this$usesKotlin) {
            for (Configuration conf : $this$usesKotlin.getProject().getConfigurations()) {
                try {
                    for (Object e : conf.getResolvedConfiguration().getResolvedArtifacts()) {
                        Intrinsics.checkNotNullExpressionValue(e, (String)"conf.resolvedConfiguration.resolvedArtifacts");
                        ResolvedArtifact artifact = (ResolvedArtifact)e;
                        String string = artifact.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.name");
                        if (!StringsKt.startsWith$default((String)string, (String)"kotlin-stdlib", (boolean)false, (int)2, null)) continue;
                        return true;
                    }
                }
                catch (Exception exception) {
                }
            }
            return false;
        }

        public static final /* synthetic */ String access$targetType(Companion $this, Project $receiver) {
            return $this.targetType($receiver);
        }

        public static final /* synthetic */ boolean access$usesKotlin(Companion $this, Project $receiver) {
            return $this.usesKotlin($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

