/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer.build;

import io.realm.transformer.BytecodeModifier;
import io.realm.transformer.ManagedClassPool;
import io.realm.transformer.ProjectMetaData;
import io.realm.transformer.RealmTransformer;
import io.realm.transformer.RealmTransformerKt;
import io.realm.transformer.build.BuildTemplate;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import javassist.ClassPool;
import javassist.CtClass;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010-\u001a\u00020.2\u0006\u0010\f\u001a\u00020/H\u0002J\u001e\u00100\u001a\u00020.2\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H$J$\u00100\u001a\u00020.2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H$J\u0006\u00105\u001a\u00020.J\u0006\u00106\u001a\u00020.J$\u00107\u001a\u00020.2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a082\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a08H$J\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020\u001f0:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001a08H$J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f08J\u0006\u0010<\u001a\u00020=J\u0006\u0010>\u001a\u00020.J\u0016\u0010?\u001a\u00020.2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005H&J\u000e\u0010@\u001a\u00020.2\u0006\u00101\u001a\u000202J\b\u0010A\u001a\u00020.H&J\u0006\u0010B\u001a\u00020.R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001f0(X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006C"}, d2={"Lio/realm/transformer/build/BuildTemplate;", "", "metadata", "Lio/realm/transformer/ProjectMetaData;", "allJars", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "outputProvider", "Ljava/util/jar/JarOutputStream;", "transform", "Lio/realm/transformer/RealmTransformer;", "(Lio/realm/transformer/ProjectMetaData;Lorg/gradle/api/provider/ListProperty;Ljava/util/jar/JarOutputStream;Lio/realm/transformer/RealmTransformer;)V", "classPool", "Lio/realm/transformer/ManagedClassPool;", "getClassPool", "()Lio/realm/transformer/ManagedClassPool;", "setClassPool", "(Lio/realm/transformer/ManagedClassPool;)V", "inputs", "Lorg/gradle/api/file/Directory;", "getInputs", "()Lorg/gradle/api/provider/ListProperty;", "setInputs", "(Lorg/gradle/api/provider/ListProperty;)V", "outputClassNames", "", "", "getOutputClassNames", "()Ljava/util/Set;", "outputModelClasses", "Ljava/util/ArrayList;", "Ljavassist/CtClass;", "Lkotlin/collections/ArrayList;", "getOutputModelClasses", "()Ljava/util/ArrayList;", "getOutputProvider", "()Ljava/util/jar/JarOutputStream;", "outputReferencedClassNames", "getOutputReferencedClassNames", "processedClasses", "", "getProcessedClasses", "()Ljava/util/Map;", "getTransform", "()Lio/realm/transformer/RealmTransformer;", "addBootClassesToClassPool", "", "Ljavassist/ClassPool;", "categorizeClassNames", "referencedInputs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "jarFiles", "directoryFiles", "copyProcessedClasses", "copyResourceFiles", "filterForModelClasses", "", "findModelClasses", "", "classNames", "hasNoOutput", "", "markMediatorsAsTransformed", "prepareOutputClasses", "prepareReferencedClasses", "transformDirectAccessToModelFields", "transformModelClasses", "realm-transformer"})
public abstract class BuildTemplate {
    @NotNull
    private final ProjectMetaData metadata;
    @NotNull
    private final ListProperty<RegularFile> allJars;
    @NotNull
    private final JarOutputStream outputProvider;
    @NotNull
    private final RealmTransformer transform;
    protected ListProperty<Directory> inputs;
    protected ManagedClassPool classPool;
    @NotNull
    private final Set<String> outputClassNames;
    @NotNull
    private final Set<String> outputReferencedClassNames;
    @NotNull
    private final ArrayList<CtClass> outputModelClasses;
    @NotNull
    private final Map<String, CtClass> processedClasses;

    public BuildTemplate(@NotNull ProjectMetaData metadata, @NotNull ListProperty<RegularFile> allJars, @NotNull JarOutputStream outputProvider, @NotNull RealmTransformer transform) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(allJars, (String)"allJars");
        Intrinsics.checkNotNullParameter((Object)outputProvider, (String)"outputProvider");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        this.metadata = metadata;
        this.allJars = allJars;
        this.outputProvider = outputProvider;
        this.transform = transform;
        this.outputClassNames = new HashSet();
        this.outputReferencedClassNames = new HashSet();
        this.outputModelClasses = new ArrayList();
        this.processedClasses = new LinkedHashMap();
    }

    @NotNull
    protected final JarOutputStream getOutputProvider() {
        return this.outputProvider;
    }

    @NotNull
    public final RealmTransformer getTransform() {
        return this.transform;
    }

    @NotNull
    protected final ListProperty<Directory> getInputs() {
        ListProperty<Directory> listProperty = this.inputs;
        if (listProperty != null) {
            return listProperty;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"inputs");
        return null;
    }

    protected final void setInputs(@NotNull ListProperty<Directory> listProperty) {
        Intrinsics.checkNotNullParameter(listProperty, (String)"<set-?>");
        this.inputs = listProperty;
    }

    @NotNull
    protected final ManagedClassPool getClassPool() {
        ManagedClassPool managedClassPool = this.classPool;
        if (managedClassPool != null) {
            return managedClassPool;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"classPool");
        return null;
    }

    protected final void setClassPool(@NotNull ManagedClassPool managedClassPool) {
        Intrinsics.checkNotNullParameter((Object)managedClassPool, (String)"<set-?>");
        this.classPool = managedClassPool;
    }

    @NotNull
    protected final Set<String> getOutputClassNames() {
        return this.outputClassNames;
    }

    @NotNull
    protected final Set<String> getOutputReferencedClassNames() {
        return this.outputReferencedClassNames;
    }

    @NotNull
    protected final ArrayList<CtClass> getOutputModelClasses() {
        return this.outputModelClasses;
    }

    @NotNull
    protected final Map<String, CtClass> getProcessedClasses() {
        return this.processedClasses;
    }

    public abstract void prepareOutputClasses(@NotNull ListProperty<Directory> var1);

    protected abstract void categorizeClassNames(@NotNull ListProperty<Directory> var1, @NotNull Set<String> var2);

    protected abstract void categorizeClassNames(@NotNull ConfigurableFileCollection var1, @NotNull Set<String> var2);

    public final boolean hasNoOutput() {
        return this.outputClassNames.isEmpty();
    }

    public final void prepareReferencedClasses(@NotNull ConfigurableFileCollection referencedInputs) {
        Intrinsics.checkNotNullParameter((Object)referencedInputs, (String)"referencedInputs");
        this.categorizeClassNames(referencedInputs, this.outputReferencedClassNames);
        this.setClassPool(new ManagedClassPool(this.getInputs(), referencedInputs));
        this.addBootClassesToClassPool(this.getClassPool());
        RealmTransformerKt.getLogger().debug("ClassPool contains Realm classes: " + (this.getClassPool().getOrNull("io.realm.RealmList") != null));
        this.filterForModelClasses(this.outputClassNames, this.outputReferencedClassNames);
    }

    protected abstract void filterForModelClasses(@NotNull Set<String> var1, @NotNull Set<String> var2);

    /*
     * WARNING - void declaration
     */
    public final void markMediatorsAsTransformed() {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        CtClass ctClass = this.getClassPool().get("io.realm.internal.RealmProxyMediator");
        Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"classPool.get(\"io.realm.\u2026rnal.RealmProxyMediator\")");
        CtClass baseProxyMediator = ctClass;
        Pattern pattern = Pattern.compile("^io\\.realm\\.[^.]+Mediator$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^io\\\\.realm\\\\.[^.]+Mediator$\")");
        Pattern mediatorPattern = pattern;
        Iterable iterable = this.outputClassNames;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!mediatorPattern.matcher(it).find()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getClassPool().getCtClass(it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CtClass)element$iv$iv;
            boolean bl = false;
            if (!it.getSuperclass().equals((Object)baseProxyMediator)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection proxyMediatorClasses = (List)destination$iv$iv;
        RealmTransformerKt.getLogger().debug("Proxy Mediator Classes: " + CollectionsKt.joinToString$default((Iterable)proxyMediatorClasses, (CharSequence)",", null, null, (int)0, null, (Function1)markMediatorsAsTransformed.1.INSTANCE, (int)30, null));
        Iterable $this$forEach$iv = proxyMediatorClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtClass it2 = (CtClass)element$iv;
            boolean bl = false;
            BytecodeModifier.Companion.overrideTransformedMarker(it2);
            Map<String, CtClass> map = this.processedClasses;
            String string = it2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            map.put(string, it2);
        }
    }

    public final void transformModelClasses() {
        Iterable $this$forEach$iv = this.outputModelClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtClass it = (CtClass)element$iv;
            boolean bl = false;
            RealmTransformerKt.getLogger().debug("Modify model class: " + it.getName());
            BytecodeModifier.Companion.addRealmAccessors(it);
            BytecodeModifier.Companion.addRealmProxyInterface(it, this.getClassPool());
            BytecodeModifier.Companion.callInjectObjectContextFromConstructors(it);
            Map<String, CtClass> map = this.processedClasses;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            map.put(string, it);
        }
    }

    public abstract void transformDirectAccessToModelFields();

    public final void copyProcessedClasses() {
        for (Map.Entry<String, CtClass> entry : this.processedClasses.entrySet()) {
            String fqname = entry.getKey();
            CtClass clazz = entry.getValue();
            this.outputProvider.putNextEntry(new JarEntry(StringsKt.replace$default((String)fqname, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class"));
            this.outputProvider.write(clazz.toBytecode());
            this.outputProvider.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyResourceFiles() {
        Object object = this.getInputs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inputs.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Directory directory = (Directory)element$iv;
            boolean bl = false;
            String dirName = directory.getAsFile().getAbsolutePath() + File.separator;
            File file = directory.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"directory.asFile");
            Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)file, null, (int)1, null)), (Function1)copyResourceFiles.1.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                File file2 = (File)element$iv2;
                boolean bl2 = false;
                String string = file2.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
                if (StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) continue;
                String string2 = file2.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.absolutePath");
                String pathWithoutPrefix = StringsKt.removePrefix((String)string2, (CharSequence)dirName);
                String zipEntryPath = StringsKt.replace$default((String)pathWithoutPrefix, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                this.outputProvider.putNextEntry(new JarEntry(zipEntryPath));
                this.outputProvider.write(FilesKt.readBytes((File)file2));
                this.outputProvider.closeEntry();
            }
        }
        Object object2 = this.allJars.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"allJars.get()");
        $this$forEach$iv = (Iterable)object2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegularFile file = (RegularFile)element$iv;
            boolean bl = false;
            JarFile jarFile = new JarFile(file.getAsFile());
            Enumeration<JarEntry> enumeration = jarFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"jarFile.entries()");
            Iterator iterator = CollectionsKt.iterator(enumeration);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"jarFile.entries()");
                JarEntry jarEntry = (JarEntry)e;
                this.outputProvider.putNextEntry(new JarEntry(jarEntry.getName()));
                Closeable closeable = jarFile.getInputStream(jarEntry);
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.outputProvider.write(ByteStreamsKt.readBytes((InputStream)it));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                this.outputProvider.closeEntry();
            }
            jarFile.close();
        }
        this.getClassPool().close();
    }

    private final void addBootClassesToClassPool(ClassPool classPool) {
        try {
            Iterable $this$forEach$iv = this.metadata.getBootClassPath();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String path;
                File it = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getAbsolutePath(), (String)"it.absolutePath");
                RealmTransformerKt.getLogger().debug("Add boot class " + path + " to class pool.");
                classPool.appendClassPath(path);
            }
        }
        catch (Exception e) {
            RealmTransformerKt.getLogger().debug("Cannot get bootClasspath caused by: ", (Throwable)e);
        }
    }

    @NotNull
    public final Set<CtClass> getOutputModelClasses() {
        return CollectionsKt.toSet((Iterable)this.outputModelClasses);
    }

    @NotNull
    protected abstract Collection<CtClass> findModelClasses(@NotNull Set<String> var1);
}

