/*
 * Decompiled with CFR 0.152.
 */
package io.realm.analytics;

import io.realm.transformer.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/realm/analytics/ComputerIdentifierGenerator;", "", "()V", "Companion", "realm-transformer"})
public final class ComputerIdentifierGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String UNKNOWN = "unknown";
    @NotNull
    private static final String OS;
    private static final boolean isWindows;
    private static final boolean isMac;
    private static final boolean isLinux;

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        OS = string3;
        isWindows = StringsKt.contains$default((CharSequence)OS, (CharSequence)"win", (boolean)false, (int)2, null);
        isMac = StringsKt.contains$default((CharSequence)OS, (CharSequence)"mac", (boolean)false, (int)2, null);
        isLinux = StringsKt.contains$default((CharSequence)OS, (CharSequence)"inux", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u0004J\b\u0010\u000b\u001a\u00020\u0004H\u0002J\b\u0010\f\u001a\u00020\u0004H\u0002J\b\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/realm/analytics/ComputerIdentifierGenerator$Companion;", "", "()V", "OS", "", "UNKNOWN", "isLinux", "", "isMac", "isWindows", "get", "getLinuxMacAddress", "getMacOsIdentifier", "getWindowsIdentifier", "realm-transformer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String get() {
            String string;
            try {
                string = isWindows ? this.getWindowsIdentifier() : (isMac ? this.getMacOsIdentifier() : (isLinux ? this.getLinuxMacAddress() : ComputerIdentifierGenerator.UNKNOWN));
            }
            catch (Exception e) {
                string = ComputerIdentifierGenerator.UNKNOWN;
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String getLinuxMacAddress() throws FileNotFoundException, NoSuchAlgorithmException {
            String string;
            File machineId = new File("/var/lib/dbus/machine-id");
            if (!machineId.exists()) {
                machineId = new File("/etc/machine-id");
            }
            if (!machineId.exists()) {
                return ComputerIdentifierGenerator.UNKNOWN;
            }
            Scanner scanner = null;
            try {
                scanner = new Scanner(machineId);
                String id = scanner.useDelimiter("\\A").next();
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                String string2 = id;
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                string = Utils.hexStringify(Utils.sha256Hash(byArray));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n                scanne\u2026teArray()))\n            }");
                scanner.close();
            }
            catch (Throwable throwable) {
                Scanner scanner2 = scanner;
                if (scanner2 != null) {
                    scanner2.close();
                }
                throw throwable;
            }
            return string;
        }

        private final String getMacOsIdentifier() throws SocketException, NoSuchAlgorithmException {
            NetworkInterface networkInterface = NetworkInterface.getByName("en0");
            byte[] hardwareAddress = networkInterface.getHardwareAddress();
            String string = Utils.hexStringify(Utils.sha256Hash(hardwareAddress));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hexStringify(Utils.sha256Hash(hardwareAddress))");
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String getWindowsIdentifier() throws IOException, NoSuchAlgorithmException {
            String string;
            Runtime runtime = Runtime.getRuntime();
            String[] stringArray = new String[]{"wmic", "csproduct", "get", "UUID"};
            Process process = runtime.exec(stringArray);
            String result = null;
            InputStream is = process.getInputStream();
            Scanner sc = new Scanner(process.getInputStream());
            try {
                while (sc.hasNext()) {
                    String next = sc.next();
                    Intrinsics.checkNotNullExpressionValue((Object)next, (String)"next");
                    if (!StringsKt.contains$default((CharSequence)next, (CharSequence)"UUID", (boolean)false, (int)2, null)) continue;
                    String string2 = sc.next();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sc.next()");
                    String $this$trim$iv = string2;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    result = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    break;
                }
            }
            finally {
                is.close();
            }
            String string3 = result;
            if (string3 == null) {
                string = ComputerIdentifierGenerator.UNKNOWN;
            } else {
                String string4 = string3;
                byte[] byArray = string4.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                String string5 = Utils.hexStringify(Utils.sha256Hash(byArray));
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"hexStringify(Utils.sha25\u2026sh(result.toByteArray()))");
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

