/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer;

import io.realm.analytics.RealmAnalytics;
import io.realm.transformer.ProjectMetaData;
import io.realm.transformer.Stopwatch;
import io.realm.transformer.build.BuildTemplate;
import io.realm.transformer.build.FullBuild;
import io.realm.transformer.build.IncrementalBuild;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.List;
import java.util.Set;
import java.util.jar.JarOutputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001bH\u0002J\u0010\u00106\u001a\u0002042\u0006\u00107\u001a\u000208H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0013\u0010\u0013\u001a\u00020\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u0014\u0010\u001f\u001a\u00020 8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0007R\u0014\u0010%\u001a\u00020&8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0010R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0007R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0007R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0007R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0007\u00a8\u00069"}, d2={"Lio/realm/transformer/RealmTransformerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "agpVersion", "Lorg/gradle/api/provider/Property;", "", "getAgpVersion", "()Lorg/gradle/api/provider/Property;", "appId", "getAppId", "areIncrementalBuildsDisabled", "", "getAreIncrementalBuildsDisabled", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "gradleVersion", "getGradleVersion", "inputDirectories", "getInputDirectories", "inputDirectoriesInternal", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/Directory;", "getInputDirectoriesInternal", "()Lorg/gradle/api/provider/ListProperty;", "inputJars", "Lorg/gradle/api/file/RegularFile;", "getInputJars", "minSdk", "getMinSdk", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "offline", "getOffline", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "referencedInputs", "getReferencedInputs", "targetSdk", "getTargetSdk", "targetType", "getTargetType", "usesKotlin", "getUsesKotlin", "usesSync", "getUsesSync", "touchJarFile", "", "jarFile", "transform", "inputChanges", "Lorg/gradle/work/InputChanges;", "realm-transformer"})
public abstract class RealmTransformerTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection inputDirectories;

    public RealmTransformerTask() {
        Object[] objectArray = new Object[]{this.getInputDirectoriesInternal()};
        ConfigurableFileCollection configurableFileCollection = this.getObjectFactory().fileCollection().from(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"objectFactory.fileCollec\u2026inputDirectoriesInternal)");
        this.inputDirectories = configurableFileCollection;
    }

    @Inject
    @NotNull
    public abstract ObjectFactory getObjectFactory();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getReferencedInputs();

    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getInputJars();

    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public final ConfigurableFileCollection getInputDirectories() {
        return this.inputDirectories;
    }

    @Internal
    @NotNull
    public abstract ListProperty<Directory> getInputDirectoriesInternal();

    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getBootClasspath();

    @Input
    @NotNull
    public abstract Property<String> getTargetType();

    @Input
    @NotNull
    public abstract Property<Boolean> getOffline();

    @Input
    @NotNull
    public abstract Property<Boolean> getUsesKotlin();

    @Input
    @NotNull
    public abstract Property<String> getTargetSdk();

    @Input
    @NotNull
    public abstract Property<String> getMinSdk();

    @Input
    @NotNull
    public abstract Property<String> getAgpVersion();

    @Input
    @NotNull
    public abstract Property<String> getAppId();

    @Input
    @NotNull
    public abstract Property<String> getGradleVersion();

    @Input
    @NotNull
    public abstract Property<Boolean> getUsesSync();

    @OutputFiles
    @NotNull
    public abstract RegularFileProperty getOutput();

    @Input
    @NotNull
    public abstract Property<Boolean> getAreIncrementalBuildsDisabled();

    private final void touchJarFile(RegularFile jarFile) {
        if (!jarFile.getAsFile().exists()) {
            new JarOutputStream(new BufferedOutputStream(new FileOutputStream(((RegularFile)this.getOutput().get()).getAsFile()))).close();
        }
    }

    @TaskAction
    public final void transform(@NotNull InputChanges inputChanges) {
        BuildTemplate buildTemplate;
        Object object;
        RealmAnalytics realmAnalytics;
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        Set set = this.getBootClasspath().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"bootClasspath.files");
        Object object2 = this.getUsesKotlin().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"usesKotlin.get()");
        boolean bl = (Boolean)object2;
        Object object3 = this.getTargetType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"targetType.get()");
        String string = (String)object3;
        Object object4 = this.getTargetSdk().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"targetSdk.get()");
        String string2 = (String)object4;
        Object object5 = this.getMinSdk().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"minSdk.get()");
        String string3 = (String)object5;
        Object object6 = this.getAgpVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"agpVersion.get()");
        String string4 = (String)object6;
        Object object7 = this.getAppId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"appId.get()");
        String string5 = (String)object7;
        Object object8 = this.getGradleVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"gradleVersion.get()");
        String string6 = (String)object8;
        Object object9 = this.getUsesSync().get();
        Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"usesSync.get()");
        boolean bl2 = (Boolean)object9;
        Object object10 = this.getOffline().get();
        Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"offline.get()");
        ProjectMetaData metadata = new ProjectMetaData(set, bl, string, string2, string3, string4, string5, string6, bl2, (Boolean)object10);
        try {
            RealmAnalytics $this$transform_u24lambda_u2d0 = realmAnalytics = new RealmAnalytics();
            boolean bl3 = false;
            $this$transform_u24lambda_u2d0.calculateAnalyticsData(metadata);
        }
        catch (Exception e) {
            this.getLogger().debug("Could not calculate Realm analytics data:\n" + e);
            realmAnalytics = null;
        }
        RealmAnalytics analytics = realmAnalytics;
        Stopwatch timer = new Stopwatch();
        Function0 exitTransform2 = (Function0)new Function0<Unit>(timer, analytics){
            final /* synthetic */ Stopwatch $timer;
            final /* synthetic */ RealmAnalytics $analytics;
            {
                this.$timer = $timer;
                this.$analytics = $analytics;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                Unit unit;
                this.$timer.stop();
                RealmAnalytics realmAnalytics = this.$analytics;
                if (realmAnalytics != null) {
                    realmAnalytics.execute();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        };
        timer.start("Realm Transform time");
        RegularFile jarFile = (RegularFile)this.getOutput().get();
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)jarFile, (String)"jarFile");
        this.touchJarFile(jarFile);
        FileSystem fileSystem = FileSystems.newFileSystem(((RegularFile)this.getOutput().get()).getAsFile().toPath(), null);
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"output.get().let { jarFi\u2026toPath(), null)\n        }");
        FileSystem jarFileOutput = fileSystem;
        Object object11 = this.getAreIncrementalBuildsDisabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"areIncrementalBuildsDisabled.get()");
        if (((Boolean)object11).booleanValue() || !inputChanges.isIncremental()) {
            List list = (List)this.getInputJars().get();
            object = this.inputDirectories;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get()");
            buildTemplate = new FullBuild(metadata, list, jarFileOutput, (ConfigurableFileCollection)object);
        } else {
            Iterable iterable = inputChanges.getFileChanges((FileCollection)this.inputDirectories);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"inputChanges.getFileChanges(inputDirectories)");
            Iterable fileChanges = iterable;
            object = (List)this.getInputJars().get();
            ConfigurableFileCollection configurableFileCollection = this.inputDirectories;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get()");
            buildTemplate = new IncrementalBuild(metadata, fileChanges, (List<? extends RegularFile>)object, configurableFileCollection, jarFileOutput);
        }
        BuildTemplate build = buildTemplate;
        build.prepareOutputClasses();
        Stopwatch.splitTime$default(timer, "Prepare output classes", false, 2, null);
        if (build.hasNoOutput()) {
            exitTransform2.invoke();
            return;
        }
        build.prepareReferencedClasses(this.getReferencedInputs());
        Stopwatch.splitTime$default(timer, "Prepare referenced classes", false, 2, null);
        build.markMediatorsAsTransformed();
        Stopwatch.splitTime$default(timer, "Mark mediators as transformed", false, 2, null);
        build.transformModelClasses();
        Stopwatch.splitTime$default(timer, "Transform model classes", false, 2, null);
        build.transformDirectAccessToModelFields();
        Stopwatch.splitTime$default(timer, "Transform references to model fields", false, 2, null);
        build.copyProcessedClasses();
        Stopwatch.splitTime$default(timer, "Copy processed classes", false, 2, null);
        build.copyResourceFiles();
        Stopwatch.splitTime$default(timer, "Copy jar files", false, 2, null);
        jarFileOutput.close();
        exitTransform2.invoke();
    }
}

