/*
 * Copyright 2018 Realm Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.realm.transformer.ext

import com.android.build.gradle.BaseExtension
import org.gradle.api.Project
import java.io.File

/**
 * Returns the `targetSdk` property for this project if it is available.
 */
fun Project.getTargetSdk(): String? {
    return getAndroidExtension(this).defaultConfig?.targetSdkVersion?.apiString
}

/**
 * Returns the `minSdk` property for this project if it is available.
 */
fun Project.getMinSdk(): String? {
    return getAndroidExtension(this).defaultConfig?.minSdkVersion?.apiString
}

/**
 * Returns the `bootClasspath` for this project
 */
fun Project.getBootClasspath(): List<File> {
    return getAndroidExtension(this).bootClasspath ?: listOf()
}

private fun getAndroidExtension(project: Project): BaseExtension {
    // This will always be present, otherwise the android build would not be able to
    // trigger the transformer code in the first place.
    return project.extensions.getByName("android") as BaseExtension
}
