/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0013\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u001a\u001a\u00020\u0017R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\f\"\u0004\b\u0015\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lio/realm/transformer/Stopwatch;", "", "()V", "label", "", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "lastSplit", "", "getLastSplit", "()J", "setLastSplit", "(J)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "start", "getStart", "setStart", "splitTime", "", "reportDiffFromLastSplit", "", "stop", "realm-transformer"})
public final class Stopwatch {
    @NotNull
    private final Logger logger;
    private long start;
    private long lastSplit;
    @NotNull
    public String label;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final long getStart() {
        return this.start;
    }

    public final void setStart(long l) {
        this.start = l;
    }

    public final long getLastSplit() {
        return this.lastSplit;
    }

    public final void setLastSplit(long l) {
        this.lastSplit = l;
    }

    @NotNull
    public final String getLabel() {
        String string = this.label;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"label");
        }
        return string;
    }

    public final void setLabel(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.label = string;
    }

    public final void start(@NotNull String label) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        if (this.start != -1L) {
            throw (Throwable)new IllegalStateException("Stopwatch was already started");
        }
        this.label = label;
        this.lastSplit = this.start = System.nanoTime();
    }

    public final void splitTime(@NotNull String label, boolean reportDiffFromLastSplit) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        long split = System.nanoTime();
        long diff = reportDiffFromLastSplit ? split - this.lastSplit : split - this.start;
        this.lastSplit = split;
        this.logger.debug(label + ": " + TimeUnit.NANOSECONDS.toMillis(diff) + " ms.");
    }

    public static /* synthetic */ void splitTime$default(Stopwatch stopwatch, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        stopwatch.splitTime(string, bl);
    }

    public final void stop() {
        long stop = System.nanoTime();
        long diff = stop - this.start;
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.label;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"label");
        }
        this.logger.debug(stringBuilder.append(string).append(": ").append(TimeUnit.NANOSECONDS.toMillis(diff)).append(" ms.").toString());
    }

    public Stopwatch() {
        Logger logger = LoggerFactory.getLogger((String)"realm-stopwatch");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\"realm-stopwatch\")");
        this.logger = logger;
        this.start = -1L;
        this.lastSplit = -1L;
    }
}

