/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer.build;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.google.common.io.Files;
import io.realm.transformer.BytecodeModifier;
import io.realm.transformer.ManagedClassPool;
import io.realm.transformer.RealmTransformerKt;
import io.realm.transformer.build.BuildTemplate;
import io.realm.transformer.ext.ProjectExtKt;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javassist.ClassPool;
import javassist.CtClass;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010)\u001a\u00020*2\u0006\u0010\t\u001a\u00020+H\u0002J2\u0010,\u001a\u00020*2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H$J\u0006\u00100\u001a\u00020*J\u0016\u00100\u001a\u00020*2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J$\u00101\u001a\u00020*2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u0018022\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001802H$J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\u001d0-2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001802H$J\u0018\u00105\u001a\u0002062\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00107\u001a\u000208H\u0004J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d02J\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020*J\u0016\u0010<\u001a\u00020*2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H&J\u0014\u0010=\u001a\u00020*2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00110-J\b\u0010?\u001a\u00020*H&J\u0006\u0010@\u001a\u00020*R\u001a\u0010\t\u001a\u00020\nX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006A"}, d2={"Lio/realm/transformer/build/BuildTemplate;", "", "project", "Lorg/gradle/api/Project;", "outputProvider", "Lcom/android/build/api/transform/TransformOutputProvider;", "transform", "Lcom/android/build/api/transform/Transform;", "(Lorg/gradle/api/Project;Lcom/android/build/api/transform/TransformOutputProvider;Lcom/android/build/api/transform/Transform;)V", "classPool", "Lio/realm/transformer/ManagedClassPool;", "getClassPool", "()Lio/realm/transformer/ManagedClassPool;", "setClassPool", "(Lio/realm/transformer/ManagedClassPool;)V", "inputs", "", "Lcom/android/build/api/transform/TransformInput;", "getInputs", "()Ljava/util/Collection;", "setInputs", "(Ljava/util/Collection;)V", "outputClassNames", "", "", "getOutputClassNames", "()Ljava/util/Set;", "outputModelClasses", "Ljava/util/ArrayList;", "Ljavassist/CtClass;", "Lkotlin/collections/ArrayList;", "getOutputModelClasses", "()Ljava/util/ArrayList;", "getOutputProvider", "()Lcom/android/build/api/transform/TransformOutputProvider;", "outputReferencedClassNames", "getOutputReferencedClassNames", "getProject", "()Lorg/gradle/api/Project;", "getTransform", "()Lcom/android/build/api/transform/Transform;", "addBootClassesToClassPool", "", "Ljavassist/ClassPool;", "categorizeClassNames", "", "directoryFiles", "referencedFiles", "copyResourceFiles", "filterForModelClasses", "", "findModelClasses", "classNames", "getOutputFile", "Ljava/io/File;", "format", "Lcom/android/build/api/transform/Format;", "hasNoOutput", "", "markMediatorsAsTransformed", "prepareOutputClasses", "prepareReferencedClasses", "referencedInputs", "transformDirectAccessToModelFields", "transformModelClasses", "realm-transformer"})
public abstract class BuildTemplate {
    @NotNull
    protected Collection<TransformInput> inputs;
    @NotNull
    protected ManagedClassPool classPool;
    @NotNull
    private final Set<String> outputClassNames;
    @NotNull
    private final Set<String> outputReferencedClassNames;
    @NotNull
    private final ArrayList<CtClass> outputModelClasses;
    @NotNull
    private final Project project;
    @NotNull
    private final TransformOutputProvider outputProvider;
    @NotNull
    private final Transform transform;

    @NotNull
    protected final Collection<TransformInput> getInputs() {
        Collection<TransformInput> collection = this.inputs;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputs");
        }
        return collection;
    }

    protected final void setInputs(@NotNull Collection<TransformInput> collection) {
        Intrinsics.checkParameterIsNotNull(collection, (String)"<set-?>");
        this.inputs = collection;
    }

    @NotNull
    protected final ManagedClassPool getClassPool() {
        ManagedClassPool managedClassPool = this.classPool;
        if (managedClassPool == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classPool");
        }
        return managedClassPool;
    }

    protected final void setClassPool(@NotNull ManagedClassPool managedClassPool) {
        Intrinsics.checkParameterIsNotNull((Object)managedClassPool, (String)"<set-?>");
        this.classPool = managedClassPool;
    }

    @NotNull
    protected final Set<String> getOutputClassNames() {
        return this.outputClassNames;
    }

    @NotNull
    protected final Set<String> getOutputReferencedClassNames() {
        return this.outputReferencedClassNames;
    }

    @NotNull
    protected final ArrayList<CtClass> getOutputModelClasses() {
        return this.outputModelClasses;
    }

    public abstract void prepareOutputClasses(@NotNull Collection<TransformInput> var1);

    protected abstract void categorizeClassNames(@NotNull Collection<? extends TransformInput> var1, @NotNull Set<String> var2, @NotNull Set<String> var3);

    public final boolean hasNoOutput() {
        return this.outputClassNames.isEmpty();
    }

    public final void prepareReferencedClasses(@NotNull Collection<? extends TransformInput> referencedInputs) {
        Intrinsics.checkParameterIsNotNull(referencedInputs, (String)"referencedInputs");
        this.categorizeClassNames(referencedInputs, this.outputReferencedClassNames, this.outputReferencedClassNames);
        Collection<TransformInput> collection = this.inputs;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputs");
        }
        ManagedClassPool managedClassPool = this.classPool = new ManagedClassPool(collection, referencedInputs);
        if (managedClassPool == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classPool");
        }
        this.addBootClassesToClassPool(managedClassPool);
        Logger logger = RealmTransformerKt.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("ClassPool contains Realm classes: ");
        ManagedClassPool managedClassPool2 = this.classPool;
        if (managedClassPool2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classPool");
        }
        logger.debug(stringBuilder.append(managedClassPool2.getOrNull("io.realm.RealmList") != null).toString());
        this.filterForModelClasses(this.outputClassNames, this.outputReferencedClassNames);
    }

    protected abstract void filterForModelClasses(@NotNull Set<String> var1, @NotNull Set<String> var2);

    public final void markMediatorsAsTransformed() {
        Iterable $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        ManagedClassPool managedClassPool = this.classPool;
        if (managedClassPool == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classPool");
        }
        CtClass ctClass = managedClassPool.get("io.realm.internal.RealmProxyMediator");
        Intrinsics.checkExpressionValueIsNotNull((Object)ctClass, (String)"classPool.get(\"io.realm.\u2026rnal.RealmProxyMediator\")");
        CtClass baseProxyMediator = ctClass;
        Pattern pattern = Pattern.compile("^io\\.realm\\.[^.]+Mediator$");
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(\"^io\\\\.realm\\\\.[^.]+Mediator$\")");
        Pattern mediatorPattern = pattern;
        Iterable $this$filter$iv = this.outputClassNames;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!mediatorPattern.matcher(it).find()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ManagedClassPool managedClassPool2 = this.classPool;
            if (managedClassPool2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classPool");
            }
            CtClass ctClass2 = managedClassPool2.getCtClass(it);
            collection.add(ctClass2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CtClass)element$iv$iv;
            boolean bl = false;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
            if (!string.getSuperclass().equals((Object)baseProxyMediator)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection proxyMediatorClasses = (List)destination$iv$iv;
        RealmTransformerKt.getLogger().debug("Proxy Mediator Classes: " + CollectionsKt.joinToString$default((Iterable)proxyMediatorClasses, (CharSequence)",", null, null, (int)0, null, (Function1)markMediatorsAsTransformed.1.INSTANCE, (int)30, null));
        Iterable $this$forEach$iv = proxyMediatorClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtClass it2 = (CtClass)element$iv;
            boolean bl = false;
            BytecodeModifier.Companion.overrideTransformedMarker(it2);
        }
    }

    public final void transformModelClasses() {
        Iterable $this$forEach$iv = this.outputModelClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtClass it = (CtClass)element$iv;
            boolean bl = false;
            RealmTransformerKt.getLogger().debug("Modify model class: " + it.getName());
            BytecodeModifier.Companion.addRealmAccessors(it);
            ManagedClassPool managedClassPool = this.classPool;
            if (managedClassPool == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"classPool");
            }
            BytecodeModifier.Companion.addRealmProxyInterface(it, managedClassPool);
            BytecodeModifier.Companion.callInjectObjectContextFromConstructors(it);
        }
    }

    public abstract void transformDirectAccessToModelFields();

    public final void copyResourceFiles() {
        Collection<TransformInput> collection = this.inputs;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputs");
        }
        this.copyResourceFiles(collection);
        ManagedClassPool managedClassPool = this.classPool;
        if (managedClassPool == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classPool");
        }
        managedClassPool.close();
    }

    private final void copyResourceFiles(Collection<TransformInput> inputs) {
        Iterable $this$forEach$iv = inputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File dest;
            String string;
            String string2;
            boolean bl;
            File file;
            int n;
            String dirPath;
            File it;
            boolean $i$f$forEach2;
            Sequence $this$forEach$iv2;
            DirectoryInput it2;
            TransformInput it3 = (TransformInput)element$iv;
            boolean bl2 = false;
            Collection collection = it3.getDirectoryInputs();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"it.directoryInputs");
            Iterable $this$forEach$iv3 = collection;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                it2 = (DirectoryInput)element$iv2;
                boolean bl3 = false;
                DirectoryInput directoryInput = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput, (String)"it");
                File file2 = directoryInput.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.file");
                Intrinsics.checkExpressionValueIsNotNull((Object)file2.getAbsolutePath(), (String)"it.file.absolutePath");
                File file3 = it2.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"it.file");
                $this$forEach$iv2 = (Sequence)FilesKt.walkTopDown((File)file3);
                $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    it = (File)element$iv3;
                    boolean bl4 = false;
                    if (!it.isFile()) continue;
                    String string3 = it.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.absolutePath");
                    if (StringsKt.endsWith$default((String)string3, (String)".class", (boolean)false, (int)2, null)) continue;
                    RealmTransformerKt.getLogger().debug("  Copying resource file: " + it);
                    File file4 = this.getOutputFile(this.outputProvider, Format.DIRECTORY);
                    Intrinsics.checkExpressionValueIsNotNull((Object)it.getAbsolutePath(), (String)"it.absolutePath");
                    n = dirPath.length();
                    file = file4;
                    bl = false;
                    String string4 = string2;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                    String string5 = string;
                    File file5 = file;
                    dest = new File(file5, string5);
                    dest.getParentFile().mkdirs();
                    Files.copy((File)it, (File)dest);
                }
            }
            Collection collection2 = it3.getJarInputs();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"it.jarInputs");
            $this$forEach$iv3 = collection2;
            $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                it2 = (JarInput)element$iv2;
                boolean bl5 = false;
                Logger logger = RealmTransformerKt.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("Found JAR file: ");
                DirectoryInput directoryInput = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)directoryInput, (String)"it");
                File file6 = directoryInput.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"it.file");
                logger.debug(stringBuilder.append(file6.getAbsolutePath()).toString());
                File file7 = it2.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"it.file");
                Intrinsics.checkExpressionValueIsNotNull((Object)file7.getAbsolutePath(), (String)"it.file.absolutePath");
                File file8 = it2.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file8, (String)"it.file");
                $this$forEach$iv2 = (Sequence)FilesKt.walkTopDown((File)file8);
                $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    it = (File)element$iv3;
                    boolean bl6 = false;
                    if (!it.isFile()) continue;
                    String string6 = it.getAbsolutePath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"it.absolutePath");
                    if (!StringsKt.endsWith$default((String)string6, (String)".jar", (boolean)false, (int)2, null)) continue;
                    RealmTransformerKt.getLogger().debug("  Copying jar file: " + it);
                    File file9 = this.getOutputFile(this.outputProvider, Format.JAR);
                    Intrinsics.checkExpressionValueIsNotNull((Object)it.getAbsolutePath(), (String)"it.absolutePath");
                    n = dirPath.length();
                    file = file9;
                    bl = false;
                    String string7 = string2;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
                    String string8 = string;
                    File file10 = file;
                    dest = new File(file10, string8);
                    dest.getParentFile().mkdirs();
                    Files.copy((File)it, (File)dest);
                }
            }
        }
    }

    @NotNull
    protected final File getOutputFile(@NotNull TransformOutputProvider outputProvider, @NotNull Format format) {
        Intrinsics.checkParameterIsNotNull((Object)outputProvider, (String)"outputProvider");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        File file = outputProvider.getContentLocation("realm", this.transform.getInputTypes(), this.transform.getScopes(), format);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputProvider.getConten\u2026transform.scopes, format)");
        return file;
    }

    private final void addBootClassesToClassPool(ClassPool classPool) {
        try {
            Iterable $this$forEach$iv = ProjectExtKt.getBootClasspath(this.project);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String path;
                File it = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it.getAbsolutePath(), (String)"it.absolutePath");
                RealmTransformerKt.getLogger().debug("Add boot class " + path + " to class pool.");
                classPool.appendClassPath(path);
            }
        }
        catch (Exception e) {
            RealmTransformerKt.getLogger().debug("Cannot get bootClasspath caused by: ", (Throwable)e);
        }
    }

    @NotNull
    public final Set<CtClass> getOutputModelClasses() {
        return CollectionsKt.toSet((Iterable)this.outputModelClasses);
    }

    @NotNull
    protected abstract Collection<CtClass> findModelClasses(@NotNull Set<String> var1);

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TransformOutputProvider getOutputProvider() {
        return this.outputProvider;
    }

    @NotNull
    public final Transform getTransform() {
        return this.transform;
    }

    public BuildTemplate(@NotNull Project project, @NotNull TransformOutputProvider outputProvider, @NotNull Transform transform) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)outputProvider, (String)"outputProvider");
        Intrinsics.checkParameterIsNotNull((Object)transform, (String)"transform");
        this.project = project;
        this.outputProvider = outputProvider;
        this.transform = transform;
        BuildTemplate buildTemplate = this;
        boolean bl = false;
        AbstractCollection abstractCollection = new HashSet();
        buildTemplate.outputClassNames = abstractCollection;
        buildTemplate = this;
        bl = false;
        abstractCollection = new HashSet();
        buildTemplate.outputReferencedClassNames = abstractCollection;
        buildTemplate = this;
        bl = false;
        abstractCollection = new ArrayList();
        buildTemplate.outputModelClasses = abstractCollection;
    }
}

