/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import io.realm.transformer.RealmAnalytics;
import io.realm.transformer.RealmTransformerKt;
import io.realm.transformer.Stopwatch;
import io.realm.transformer.UrlEncodedAnalytics;
import io.realm.transformer.Utils;
import io.realm.transformer.build.BuildTemplate;
import io.realm.transformer.build.FullBuild;
import io.realm.transformer.build.IncrementalBuild;
import io.realm.transformer.ext.ProjectExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javassist.CtClass;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J$\u0010\u001f\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002JD\u0010 \u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010#2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Lio/realm/transformer/RealmTransformer;", "Lcom/android/build/api/transform/Transform;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getProject", "()Lorg/gradle/api/Project;", "exitTransform", "", "inputs", "", "Lcom/android/build/api/transform/TransformInput;", "outputModelClasses", "", "Ljavassist/CtClass;", "timer", "Lio/realm/transformer/Stopwatch;", "getInputTypes", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getReferencedScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "getScopes", "isIncremental", "", "sendAnalytics", "transform", "context", "Lcom/android/build/api/transform/Context;", "", "referencedInputs", "outputProvider", "Lcom/android/build/api/transform/TransformOutputProvider;", "realm-transformer"})
public final class RealmTransformer
extends Transform {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Project project;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public String getName() {
        return "RealmTransformer";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        return SetsKt.setOf((Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public boolean isIncremental() {
        return true;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        return SetsKt.mutableSetOf((Object[])new QualifiedContent.Scope[]{QualifiedContent.Scope.PROJECT});
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getReferencedScopes() {
        return SetsKt.mutableSetOf((Object[])new QualifiedContent.Scope[]{QualifiedContent.Scope.EXTERNAL_LIBRARIES, QualifiedContent.Scope.PROJECT_LOCAL_DEPS, QualifiedContent.Scope.SUB_PROJECTS, QualifiedContent.Scope.SUB_PROJECTS_LOCAL_DEPS, QualifiedContent.Scope.TESTED_CODE});
    }

    public void transform(@Nullable Context context, @Nullable Collection<TransformInput> inputs, @Nullable Collection<? extends TransformInput> referencedInputs, @Nullable TransformOutputProvider outputProvider, boolean isIncremental) {
        BuildTemplate buildTemplate;
        Stopwatch timer = new Stopwatch();
        timer.start("Realm Transform time");
        if (isIncremental) {
            TransformOutputProvider transformOutputProvider = outputProvider;
            if (transformOutputProvider == null) {
                Intrinsics.throwNpe();
            }
            buildTemplate = new IncrementalBuild(this.project, transformOutputProvider, this);
        } else {
            TransformOutputProvider transformOutputProvider = outputProvider;
            if (transformOutputProvider == null) {
                Intrinsics.throwNpe();
            }
            buildTemplate = new FullBuild(this.project, transformOutputProvider, this);
        }
        BuildTemplate build = buildTemplate;
        Collection<TransformInput> collection = inputs;
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        build.prepareOutputClasses(collection);
        Stopwatch.splitTime$default(timer, "Prepare output classes", false, 2, null);
        if (build.hasNoOutput()) {
            this.exitTransform(SetsKt.emptySet(), SetsKt.emptySet(), timer);
            return;
        }
        Collection<? extends TransformInput> collection2 = referencedInputs;
        if (collection2 == null) {
            Intrinsics.throwNpe();
        }
        build.prepareReferencedClasses(collection2);
        Stopwatch.splitTime$default(timer, "Prepare referenced classes", false, 2, null);
        build.markMediatorsAsTransformed();
        Stopwatch.splitTime$default(timer, "Mark mediators as transformed", false, 2, null);
        build.transformModelClasses();
        Stopwatch.splitTime$default(timer, "Transform model classes", false, 2, null);
        build.transformDirectAccessToModelFields();
        Stopwatch.splitTime$default(timer, "Transform references to model fields", false, 2, null);
        build.copyResourceFiles();
        Stopwatch.splitTime$default(timer, "Copy resource files", false, 2, null);
        this.exitTransform(inputs, build.getOutputModelClasses(), timer);
    }

    private final void exitTransform(Collection<? extends TransformInput> inputs, Set<? extends CtClass> outputModelClasses, Stopwatch timer) {
        timer.stop();
        this.sendAnalytics(inputs, outputModelClasses);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendAnalytics(Collection<? extends TransformInput> inputs, Set<? extends CtClass> outputModelClasses) {
        try {
            void $this$mapTo$iv$iv;
            Object object;
            boolean disableAnalytics;
            Gradle gradle = this.project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
            StartParameter startParameter = gradle.getStartParameter();
            Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.gradle.startParameter");
            boolean bl = disableAnalytics = startParameter.isOffline() || StringsKt.equals((String)"true", (String)System.getenv().get("REALM_DISABLE_ANALYTICS"), (boolean)true);
            if (inputs.isEmpty() || disableAnalytics) {
                return;
            }
            boolean containsKotlin = false;
            Iterator iterator = this.project.getConfigurations().iterator();
            block4: while (iterator.hasNext()) {
                Configuration configuration;
                Configuration configuration2 = configuration = (Configuration)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
                object = configuration2.getDependencies().iterator();
                while (object.hasNext()) {
                    Dependency dependency;
                    Dependency dependency2 = dependency = (Dependency)object.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)dependency2, (String)"dependency");
                    String string = dependency2.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependency.name");
                    if (!StringsKt.startsWith$default((String)string, (String)"kotlin-stdlib", (boolean)false, (int)2, null)) continue;
                    containsKotlin = true;
                    break block4;
                }
            }
            Iterable $this$map$iv = outputModelClasses;
            boolean $i$f$map = false;
            object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CtClass ctClass = (CtClass)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string = it.getPackageName();
                collection.add(string);
            }
            Set packages = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            String targetSdk = ProjectExtKt.getTargetSdk(this.project);
            String minSdk = ProjectExtKt.getMinSdk(this.project);
            boolean sync = Utils.isSyncEnabled(this.project);
            String target = this.project.getPlugins().findPlugin("com.android.application") != null ? "app" : (this.project.getPlugins().findPlugin("com.android.library") != null ? "library" : "unknown");
            RealmAnalytics analytics = new RealmAnalytics(packages, containsKotlin, sync, targetSdk, minSdk, target);
            ExecutorService pool = Executors.newFixedThreadPool(2);
            try {
                pool.execute(new Runnable(analytics){
                    final /* synthetic */ RealmAnalytics $analytics;

                    public final void run() {
                        new UrlEncodedAnalytics.MixPanel().execute(this.$analytics);
                    }
                    {
                        this.$analytics = realmAnalytics;
                    }
                });
                pool.execute(new Runnable(analytics){
                    final /* synthetic */ RealmAnalytics $analytics;

                    public final void run() {
                        new UrlEncodedAnalytics.Segment().execute(this.$analytics);
                    }
                    {
                        this.$analytics = realmAnalytics;
                    }
                });
                pool.awaitTermination(RealmTransformerKt.getCONNECT_TIMEOUT() + RealmTransformerKt.getREAD_TIMEOUT(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                pool.shutdownNow();
            }
        }
        catch (Exception e) {
            this.logger.debug("Could not send analytics: " + e);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public RealmTransformer(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Logger logger = LoggerFactory.getLogger((String)"realm-logger");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\"realm-logger\")");
        this.logger = logger;
    }
}

