/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer;

import io.realm.transformer.ComputerIdentifierGenerator;
import io.realm.transformer.Utils;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.util.Set;

public class RealmAnalytics {
    private static final String TOKEN = "ce0fac19508f6c8f20066d345d360fd0";
    private static final String EVENT_NAME = "Run";
    private static final String JSON_TEMPLATE = "{\n   \"event\": \"%EVENT%\",\n   \"properties\": {\n      \"token\": \"%TOKEN%\",\n      \"distinct_id\": \"%USER_ID%\",\n      \"Anonymized MAC Address\": \"%USER_ID%\",\n      \"Anonymized Bundle ID\": \"%APP_ID%\",\n      \"Binding\": \"java\",\n      \"Target\": \"%TARGET%\",\n      \"Language\": \"%LANGUAGE%\",\n      \"Sync Version\": %SYNC_VERSION%,\n      \"Realm Version\": \"%REALM_VERSION%\",\n      \"Host OS Type\": \"%OS_TYPE%\",\n      \"Host OS Version\": \"%OS_VERSION%\",\n      \"Target OS Type\": \"android\",\n      \"Target OS Version\": \"%TARGET_SDK%\",\n      \"Target OS Minimum Version\": \"%MIN_SDK%\"\n   }\n}";
    private Set<String> packages;
    private boolean usesKotlin;
    private boolean usesSync;
    private String targetSdk;
    private String minSdk;
    private String target;

    public RealmAnalytics(Set<String> packages, boolean usesKotlin, boolean usesSync, String targetSdk, String minSdk, String target) {
        this.packages = packages;
        this.usesKotlin = usesKotlin;
        this.usesSync = usesSync;
        this.targetSdk = targetSdk;
        this.minSdk = minSdk;
        this.target = target;
    }

    public String generateJson() throws SocketException, NoSuchAlgorithmException {
        return JSON_TEMPLATE.replaceAll("%EVENT%", EVENT_NAME).replaceAll("%TOKEN%", TOKEN).replaceAll("%USER_ID%", ComputerIdentifierGenerator.get()).replaceAll("%APP_ID%", this.getAnonymousAppId()).replaceAll("%TARGET%", this.target).replaceAll("%LANGUAGE%", this.usesKotlin ? "kotlin" : "java").replaceAll("%SYNC_VERSION%", this.usesSync ? "\"10.3.3\"" : "null").replaceAll("%REALM_VERSION%", "10.8.0").replaceAll("%OS_TYPE%", System.getProperty("os.name")).replaceAll("%OS_VERSION%", System.getProperty("os.version")).replaceAll("%TARGET_SDK%", this.targetSdk).replaceAll("%MIN_SDK%", this.minSdk);
    }

    public String getAnonymousAppId() throws NoSuchAlgorithmException {
        StringBuilder stringBuilder = new StringBuilder();
        for (String modelPackage : this.packages) {
            stringBuilder.append(modelPackage).append(":");
        }
        byte[] packagesBytes = stringBuilder.toString().getBytes();
        return Utils.hexStringify(Utils.sha256Hash(packagesBytes));
    }
}

