/*
 * Decompiled with CFR 0.152.
 */
package io.redskap.swagger.brake.maven;

import io.redskap.swagger.brake.core.BreakingChange;
import io.redskap.swagger.brake.maven.StarterWrapper;
import io.redskap.swagger.brake.runner.Options;
import io.redskap.swagger.brake.runner.exception.LatestArtifactDownloadException;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class Executor {
    private final StarterWrapper starter;
    private final Log log;

    public void execute(Options options) throws MojoFailureException {
        try {
            Collection<BreakingChange> bcs = this.starter.start(options);
            if (CollectionUtils.isNotEmpty(bcs)) {
                throw new MojoFailureException("Breaking change has been found. See report further details at " + options.getOutputFilePath());
            }
        }
        catch (LatestArtifactDownloadException e) {
            this.log.info((CharSequence)String.format("Latest version of the artifact could not be retrieved from %s, %s with %s:%s", options.getMavenRepoUrl(), options.getMavenSnapshotRepoUrl(), options.getGroupId(), options.getArtifactId()));
            this.log.info((CharSequence)"Assuming this is the first version of the artifact, skipping check for breaking changes", (Throwable)e);
        }
    }

    public Executor(StarterWrapper starter, Log log) {
        this.starter = starter;
        this.log = log;
    }
}

