/*
 * Decompiled with CFR 0.152.
 */
package io.redskap.swagger.brake.maven;

import io.redskap.swagger.brake.maven.RunnerParameter;
import io.redskap.swagger.brake.runner.ArtifactPackaging;
import io.redskap.swagger.brake.runner.Options;
import io.redskap.swagger.brake.runner.OutputFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OptionsFactory {
    public static Options create(RunnerParameter parameter) {
        Options options = new Options();
        options.setOldApiPath(parameter.getOldApi());
        options.setMavenRepoUrl(parameter.getMavenRepoUrl());
        options.setMavenSnapshotRepoUrl(parameter.getMavenSnapshotRepoUrl());
        options.setMavenRepoUsername(parameter.getMavenRepoUsername());
        options.setMavenRepoPassword(parameter.getMavenRepoPassword());
        options.setGroupId(parameter.getGroupId());
        options.setArtifactId(parameter.getArtifactId());
        options.setCurrentArtifactVersion(parameter.getCurrentVersion());
        options.setArtifactPackaging(OptionsFactory.resolveArtifactPackaging(parameter));
        options.setNewApiPath(parameter.getNewApi());
        options.setOutputFilePath(parameter.getOutputFilePath());
        options.setOutputFormats(OptionsFactory.resolveOutputFormats(parameter));
        options.setDeprecatedApiDeletionAllowed(parameter.getDeprecatedApiDeletionAllowed());
        options.setBetaApiExtensionName(parameter.getBetaApiExtensionName());
        options.setApiFilename(parameter.getApiFilename());
        options.setExcludedPaths(new HashSet(Optional.ofNullable(parameter.getExcludedPaths()).orElse(Collections.emptySet())));
        return options;
    }

    private static Set<OutputFormat> resolveOutputFormats(RunnerParameter parameter) {
        Collection<String> formats = parameter.getOutputFormats();
        if (CollectionUtils.isEmpty(formats)) {
            return Collections.emptySet();
        }
        return formats.stream().map(String::toUpperCase).map(OutputFormat::valueOf).collect(Collectors.toSet());
    }

    private static ArtifactPackaging resolveArtifactPackaging(RunnerParameter parameter) {
        String artifactPackaging = parameter.getArtifactPackaging();
        if (StringUtils.isBlank((CharSequence)artifactPackaging)) {
            return ArtifactPackaging.JAR;
        }
        return ArtifactPackaging.forPackaging((String)artifactPackaging.trim().toLowerCase());
    }
}

