/*
 * Decompiled with CFR 0.152.
 */
package io.redskap.swagger.brake.maven;

import com.google.common.collect.ImmutableList;
import io.redskap.swagger.brake.maven.Executor;
import io.redskap.swagger.brake.maven.OptionsFactory;
import io.redskap.swagger.brake.maven.RunnerParameter;
import io.redskap.swagger.brake.maven.StarterWrapper;
import io.redskap.swagger.brake.runner.Options;
import io.redskap.swagger.brake.runner.OptionsValidator;
import io.redskap.swagger.brake.runner.OutputFormat;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class SwaggerBrakeMojo
extends AbstractMojo {
    @Parameter(name="oldApi", required=false)
    private String oldApi;
    @Parameter(name="newApi", required=true)
    private String newApi;
    @Parameter(name="mavenRepoUrl", required=false)
    private String mavenRepoUrl;
    @Parameter(name="mavenSnapshotRepoUrl", required=false)
    private String mavenSnapshotRepoUrl;
    @Parameter(name="mavenRepoUsername", required=false)
    private String mavenRepoUsername;
    @Parameter(name="mavenRepoPassword", required=false)
    private String mavenRepoPassword;
    @Parameter(name="groupId", required=false, defaultValue="${project.groupId}")
    private String groupId;
    @Parameter(name="artifactId", required=false, defaultValue="${project.artifactId}")
    private String artifactId;
    @Parameter(name="currentVersion", required=false, defaultValue="${project.version}")
    private String currentVersion;
    @Parameter(name="packaging", required=false, defaultValue="${project.packaging}")
    private String packaging;
    @Parameter(name="outputFilePath", required=false, defaultValue="${project.build.directory}/swagger-brake")
    private String outputFilePath;
    @Parameter(name="outputFormats", required=false)
    private List<String> outputFormats;
    @Parameter(name="deprecatedApiDeletionAllowed", required=false)
    private Boolean deprecatedApiDeletionAllowed;
    @Parameter(name="betaApiExtensionName", required=false)
    private String betaApiExtensionName;
    @Parameter(name="apiFilename", required=false)
    private String apiFilename;
    @Parameter(name="excludedPaths", required=false)
    private List<String> excludedPaths;
    private final Executor executor = new Executor(new StarterWrapper(), this.getLog());
    private final OptionsValidator optionsValidator = new OptionsValidator();

    public void execute() throws MojoExecutionException, MojoFailureException {
        RunnerParameter parameter = this.createRunnerParameter();
        this.getLog().debug((CharSequence)("The following parameters are set for Swagger Brake: " + parameter.toString()));
        Options options = OptionsFactory.create(parameter);
        this.optionsValidator.validate(options);
        this.executor.execute(options);
    }

    private RunnerParameter createRunnerParameter() {
        List<String> oFormats = this.getOutputFormats();
        return RunnerParameter.builder().oldApi(this.oldApi).newApi(this.newApi).mavenRepoUrl(this.mavenRepoUrl).mavenSnapshotRepoUrl(this.mavenSnapshotRepoUrl).mavenRepoUsername(this.mavenRepoUsername).mavenRepoPassword(this.mavenRepoPassword).groupId(this.groupId).artifactId(this.artifactId).currentVersion(this.currentVersion).artifactPackaging(this.packaging).outputFilePath(this.outputFilePath).outputFormats(oFormats).deprecatedApiDeletionAllowed(this.deprecatedApiDeletionAllowed).betaApiExtensionName(this.betaApiExtensionName).apiFilename(this.apiFilename).excludedPaths(this.excludedPaths).build();
    }

    private List<String> getOutputFormats() {
        if (CollectionUtils.isNotEmpty(this.outputFormats)) {
            return this.outputFormats;
        }
        return ImmutableList.of((Object)OutputFormat.HTML.name());
    }
}

