package io.relayr.java.api;

import com.squareup.okhttp.OkHttpClient;

import javax.inject.Named;
import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import io.relayr.java.RelayrJavaApp;
import io.relayr.java.api.services.AggregatedDataService;
import io.relayr.java.api.services.NotificationService;
import io.relayr.java.api.services.RawDataService;
import retrofit.Endpoint;
import retrofit.Endpoints;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;

import static io.relayr.java.RelayrJavaApp.getLogLevel;

@Module(
        complete = false,
        library = true
)
public class ApiModule {

    private final ApiHelper helper;

    public ApiModule() {
        helper = new ApiHelper();
    }

    @SuppressWarnings("unused") @Provides @Singleton @Named("api") Endpoint apiEndpoint() {
        return Endpoints.newFixedEndpoint(RelayrJavaApp.getMainApiPoint());
    }

    @SuppressWarnings("unused") @Provides @Singleton OkHttpClient provideOkHttpClient() {
        return helper.createOkHttpClient();
    }

    @SuppressWarnings("unused") @Provides @Singleton Client provideClient(OkHttpClient client) {
        return new OkClient(client);
    }

    @SuppressWarnings("unused") @Provides @Singleton @Named("api")
    RestAdapter provideApiRestAdapter(
            @Named("api") Endpoint endpoint, Client client) {
        return helper.createAdapter(client, endpoint, ApiHelper.InterceptorType.API, getLogLevel());
    }

    @SuppressWarnings("unused") @Provides @Singleton @Named("oauth")
    RestAdapter provideOauthRestAdapter(
            @Named("api") Endpoint endpoint, Client client) {
        return helper.createAdapter(client, endpoint, ApiHelper.InterceptorType.OAUTH, getLogLevel());
    }

    @SuppressWarnings("unused") @Provides @Singleton @Named("models")
    RestAdapter provideModelsRestAdapter(
            @Named("api") Endpoint endpoint, Client client) {
        return helper.createAdapter(client, endpoint, ApiHelper.InterceptorType.MODELS, getLogLevel());
    }

    @SuppressWarnings("unused") @Provides @Singleton @Named("history")
    RestAdapter provideHistoryRestAdapter(
            @Named("history") Endpoint endpoint, Client client) {
        return helper.createAdapter(client, endpoint, ApiHelper.InterceptorType.API, getLogLevel());
    }

    @SuppressWarnings("unused") @Provides @Singleton
    OauthApi provideOauthApi(@Named("oauth") RestAdapter adapter) {
        return adapter.create(OauthApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    ChannelApi provideChannelApi(@Named("api") RestAdapter adapter) {
        return adapter.create(ChannelApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    CloudApi provideCloudApi(@Named("api") RestAdapter adapter) {
        return adapter.create(CloudApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    RelayrApi provideRelayrApi(@Named("api") RestAdapter adapter) {
        return adapter.create(RelayrApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    DeviceApi provideDeviceApi(@Named("api") RestAdapter adapter) {
        return adapter.create(DeviceApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    AccountsApi provideAccountsApi(@Named("api") RestAdapter adapter) {
        return adapter.create(AccountsApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    GroupsApi provideGroupsApi(@Named("api") RestAdapter adapter) {
        return adapter.create(GroupsApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    UserApi provideUserApi(@Named("api") RestAdapter adapter) {
        return adapter.create(UserApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    DeviceModelsApi provideDeviceModelsApi(@Named("models") RestAdapter adapter) {
        return adapter.create(DeviceModelsApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    ProjectsApi provideProjectsApi(@Named("api") RestAdapter adapter) {
        return adapter.create(ProjectsApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    PublishersApi providePublishersApi(@Named("api") RestAdapter adapter) {
        return adapter.create(PublishersApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    RuleTemplateApi provideRulesApi(@Named("api") RestAdapter adapter) {
        return adapter.create(RuleTemplateApi.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    RawDataService provideRawDataApi(@Named("api") RestAdapter adapter) {
        return adapter.create(RawDataService.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    AggregatedDataService provideAggDataApi(@Named("api") RestAdapter adapter) {
        return adapter.create(AggregatedDataService.class);
    }

    @SuppressWarnings("unused") @Provides @Singleton
    NotificationService provideNotificationsApi(@Named("api") RestAdapter adapter) {
        return adapter.create(NotificationService.class);
    }
}
