package io.relayr.java.api;

import java.util.List;

import io.relayr.java.model.Publisher;
import io.relayr.java.model.User;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.GET;
import retrofit.http.PATCH;
import retrofit.http.POST;
import retrofit.http.Path;
import rx.Observable;

public interface PublishersApi {

    /** @return list of all publishers {@link Publisher} */
    @GET("/publishers") Observable<List<Publisher>> getAllPublishers();

    /**
     * @param userId - unique relayr userId
     * @return list of all publishers {@link Publisher} for specified {@link User} id
     */
    @GET("/users/{id}/publishers")
    Observable<List<Publisher>> getUserPublishers(@Path("id") String userId);

    /**
     * @param publisherId - unique publisherId
     * @return {@link Publisher} entity for specified publisherId
     */
    @GET("/publishers/{id}") Observable<Publisher> getPublisher(@Path("id") String publisherId);

    /**
     * @param publisher - updated {@link Publisher} object
     * @return Updated {@link Publisher}
     */
    @PATCH("/publishers/{id}") Observable<Publisher> updatePublisher(@Body Publisher publisher);

    /**
     * @param publisherId - publisherId to delete
     * @return empty {@link Observable} if deleted
     */
    @DELETE("/publishers/{id}") Observable<Void> deletePublisher(@Path("id") String publisherId);

    /**
     * @param publisher - {@link Publisher} object to create
     * @return created {@link Publisher}
     */
    @POST("/publishers") Observable<Publisher> createPublisher(@Body Publisher publisher);
}
