package io.relayr.java.api.mock;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import io.relayr.java.api.AccountsApi;
import io.relayr.java.api.ChannelApi;
import io.relayr.java.api.CloudApi;
import io.relayr.java.api.DeviceApi;
import io.relayr.java.api.DeviceModelsApi;
import io.relayr.java.api.GroupsApi;
import io.relayr.java.api.services.AggregatedDataService;
import io.relayr.java.api.services.NotificationService;
import io.relayr.java.api.OauthApi;
import io.relayr.java.api.ProjectsApi;
import io.relayr.java.api.PublishersApi;
import io.relayr.java.api.RelayrApi;
import io.relayr.java.api.RuleTemplateApi;
import io.relayr.java.api.UserApi;
import io.relayr.java.api.services.RawDataService;
import io.relayr.java.storage.DeviceModelCache;

@Module(
        complete = false,
        library = true
)
public class DebugApiModule {

    @Provides @Singleton MockBackend provideMockBackend() {
        return new MockBackend();
    }

    @Provides @Singleton OauthApi provideOauthApi(MockBackend loader) {
        return new MockOauthApi(loader);
    }

    @Provides @Singleton DeviceApi provideDeviceApi(MockBackend loader) {
        return new MockDeviceApi(loader);
    }

    @Provides @Singleton RelayrApi provideRelayrApi(MockBackend loader) {
        return new MockRelayrApi(loader);
    }

    @Provides @Singleton ChannelApi provideChannelApi(MockBackend loader) {
        return new MockChannelApi(loader);
    }

    @Provides @Singleton AccountsApi provideAccountsApi(MockBackend loader) {
        return new MockAccountsApi(loader);
    }

    @Provides @Singleton UserApi provideUserApi(MockBackend loader) {
        return new MockUserApi(loader);
    }

    @Provides @Singleton GroupsApi provideGroupsApi(MockBackend loader) {
        return new MockGroupsApi(loader);
    }

    @Provides @Singleton CloudApi provideCloudApi(MockBackend loader) {
        return new MockCloudApi(loader);
    }

    @Provides @Singleton ProjectsApi provideProjectsApi(MockBackend loader) {
        return new MockProjectsApi(loader);
    }

    @Provides @Singleton PublishersApi providePublishersApi(MockBackend loader) {
        return new MockPublishersApi(loader);
    }

    @Provides @Singleton RuleTemplateApi provideRulesApi(MockBackend loader) {
        return new MockRuleTemplateApi(loader);
    }

    @Provides @Singleton DeviceModelsApi provideDeviceModelsApi(MockBackend loader) {
        return new MockDeviceModelsApi(loader);
    }

    @Provides @Singleton DeviceModelCache provideDeviceModelCache(DeviceModelsApi modelsApi, UserApi userApi) {
        return new DeviceModelCache(modelsApi, userApi);
    }

    @Provides @Singleton NotificationService provideNotificationApi(MockBackend loader) {
        return new MockNotificationService(loader);
    }

    @Provides @Singleton RawDataService provideRawDataService(MockBackend loader) {
        return new MockRawDataService(loader);
    }

    @Provides @Singleton AggregatedDataService provideAggDataService(MockBackend loader) {
        return new MockAggregatedDataService(loader);
    }

}
