package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import javax.inject.Inject;

import io.relayr.java.api.services.AggregatedDataService;
import io.relayr.java.model.aggregated.AggregatedData;
import rx.Observable;

public class MockAggregatedDataService implements AggregatedDataService {

    private final MockBackend mMockBackend;

    @Inject
    public MockAggregatedDataService(MockBackend mockBackend) {
        mMockBackend = mockBackend;
    }

    @Override
    public Observable<AggregatedData> getData(String deviceId,
                                              String path,
                                              String meaning,
                                              String start,
                                              String end,
                                              String sample,
                                              String aggregates) {

        return mMockBackend.createObservable(new TypeToken<AggregatedData>() {
        }, MockBackend.HISTORY_AGGREGATES);
    }
}
