package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import javax.inject.Inject;

import io.relayr.java.api.ChannelApi;
import io.relayr.java.model.channel.ChannelDefinition;
import io.relayr.java.model.channel.ExistingChannel;
import io.relayr.java.model.channel.DataChannel;
import io.relayr.java.model.channel.PublishChannel;
import rx.Observable;
import rx.Subscriber;

public class MockChannelApi implements ChannelApi {

    private final MockBackend mMockBackend;

    @Inject
    public MockChannelApi(MockBackend mockBackend) {
        mMockBackend = mockBackend;
    }

    @Override
    public Observable<DataChannel> create(ChannelDefinition mqttDefinition) {
        return mMockBackend.createObservable(new TypeToken<DataChannel>() {
        }, MockBackend.MQTT_CREDENTIALS);
    }

    @Override
    public Observable<Void> delete(String channelId) {
        return Observable.create(new Observable.OnSubscribe<Void>() {
            @Override
            public void call(Subscriber<? super Void> subscriber) {
                subscriber.onNext(null);
                subscriber.onCompleted();
            }
        });
    }

    @Override
    public Observable<ExistingChannel> getChannels(String deviceId) {
        return Observable.empty();
    }

    @Override
    public Observable<PublishChannel> createForDevice(ChannelDefinition mqttDefinition, String deviceId) {
        return mMockBackend.createObservable(new TypeToken<PublishChannel>() {
        }, MockBackend.MQTT_DEVICE_CHANNEL);
    }
}
