package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import java.util.List;

import javax.inject.Inject;

import io.relayr.java.api.DeviceApi;
import io.relayr.java.model.CreateDevice;
import io.relayr.java.model.Device;
import io.relayr.java.model.action.Command;
import io.relayr.java.model.action.Configuration;
import io.relayr.java.model.device.laststate.LastCommands;
import io.relayr.java.model.device.laststate.LastConfigurations;
import io.relayr.java.model.device.laststate.LastReadings;
import io.relayr.java.model.json.JsonListResponse;
import io.relayr.java.model.state.State;
import io.relayr.java.model.state.StateCommands;
import io.relayr.java.model.state.StateConfigurations;
import io.relayr.java.model.state.StateMetadata;
import io.relayr.java.model.state.StateReadings;
import retrofit.client.Response;
import retrofit.http.Path;
import retrofit.http.Query;
import rx.Observable;
import rx.Subscriber;

import static io.relayr.java.api.mock.MockBackend.DEVICE_STATE;
import static io.relayr.java.api.mock.MockBackend.DEVICE_STATE_METADATA;
import static io.relayr.java.api.mock.MockBackend.DEVICE_STATE_READINGS;
import static io.relayr.java.api.mock.MockBackend.PUBLIC_DEVICES;
import static io.relayr.java.api.mock.MockBackend.USER_DEVICE;
import static io.relayr.java.api.mock.MockBackend.USER_DEVICES_FILTERED;

public class MockDeviceApi implements DeviceApi {

    private final MockBackend backend;

    Observable emptyObservable = Observable.create(new Observable.OnSubscribe<Void>() {
        @Override
        public void call(Subscriber<? super Void> subscriber) {
            subscriber.onNext(null);
        }
    });

    @Inject public MockDeviceApi(MockBackend mockBackend) {
        backend = mockBackend;
    }

    @Override public Observable<Device> getDevice(String deviceId) {
        return backend.createObservable(new TypeToken<Device>() {
        }, USER_DEVICE);
    }

    @Override
    public Observable<JsonListResponse<Device>> getAllDevices(Integer pageNumber, Integer pageSize, String deviceIds,
                                                              String modelId, String firmwareVersion,
                                                              String deviceName, String deviceDescription) {
        return backend.createObservable(new TypeToken<JsonListResponse<Device>>() {
        }, USER_DEVICES_FILTERED);
    }

    @Override
    public Observable<Device> createDevice(CreateDevice device) {
        return backend.createObservable(new TypeToken<Device>() {
        }, USER_DEVICE);
    }

    @Override
    public Observable<Device> updateDevice(String deviceId, Device device) {
        return Observable.just(device);
    }

    @Override
    public Observable<Void> deleteDevice(String deviceId) {
        return emptyObservable;
    }

    @Override
    public Observable<Response> checkDevicePermission(String deviceId, String action) {
        return emptyObservable;
    }

    @Override
    public Observable<List<Device>> getPublicDevices(String meaning) {
        return backend.createObservable(new TypeToken<List<Device>>() {
        }, PUBLIC_DEVICES);
    }

    @Override
    public Observable<Void> sendCommand(String deviceId, Command command) {
        return emptyObservable;
    }

    @Override
    public Observable<Void> sendConfiguration(String deviceId, Configuration configuration) {
        return emptyObservable;
    }

    @Override
    public Observable<Void> setMetadata(String deviceId, String key, Object metadata) {
        return emptyObservable;
    }

    @Override public Observable<State> getState(String deviceId) {
        return backend.createObservable(new TypeToken<State>() {
        }, DEVICE_STATE);
    }

    @Override
    public Observable<StateMetadata> getMetadata(String deviceId, String name) {
        return backend.createObservable(new TypeToken<StateMetadata>() {
        }, DEVICE_STATE_METADATA);
    }

    @Override public Observable<Void> deleteMetadata(String deviceId, String key) {
        return emptyObservable;
    }

    @Override
    public Observable<StateReadings> getReadings(String deviceId, String path, String meaning) {
        return backend.createObservable(new TypeToken<StateReadings>() {
        }, DEVICE_STATE_READINGS);
    }

    @Override
    public Observable<JsonListResponse<LastReadings>> getLastReadings(String deviceId, String deviceIds, String path, String meaning) {
        return emptyObservable;
    }

    @Override
    public Observable<StateCommands> getCommands(String deviceId, String path, String name) {
        return emptyObservable;
    }

    @Override
    public Observable<JsonListResponse<LastCommands>> getLastCommands(String deviceId, String deviceIds, String path, String name) {
        return emptyObservable;
    }

    @Override
    public Observable<StateConfigurations> getConfigurations(String deviceId, String path, String name) {
        return emptyObservable;
    }

    @Override
    public Observable<JsonListResponse<LastConfigurations>> getLastConfigurations(String deviceId, String path, String name) {
        return emptyObservable;
    }
}
