package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import javax.inject.Inject;

import io.relayr.java.api.GroupsApi;
import io.relayr.java.model.groups.Group;
import io.relayr.java.model.groups.GroupCreate;
import io.relayr.java.model.groups.GroupDeviceAdd;
import io.relayr.java.model.groups.PositionUpdate;
import rx.Observable;

import static io.relayr.java.api.mock.MockBackend.USER_GROUP;

public class MockGroupsApi implements GroupsApi {

    private final MockBackend mMockBackend;

    @Inject
    public MockGroupsApi(MockBackend mockBackend) {
        mMockBackend = mockBackend;
    }

    @Override public Observable<Group> createGroup(GroupCreate group) {
        return mMockBackend.createObservable(new TypeToken<Group>() {
        }, USER_GROUP);
    }

    @Override public Observable<Group> getGroup(String groupId) {
        return mMockBackend.createObservable(new TypeToken<Group>() {
        }, USER_GROUP);
    }

    @Override
    public Observable<Void> updateGroup(GroupCreate group, String groupId) {
        return Observable.empty();
    }

    @Override
    public Observable<Void> addDevice(String groupId, GroupDeviceAdd deviceIds) {
        return null;
    }

    @Override
    public Observable<Void> deleteDevice(String groupId, String deviceId) {
        return null;
    }

    @Override
    public Observable<Void> updateDevicePosition(String groupId, String deviceId, PositionUpdate update) {
        return null;
    }

    @Override public Observable<Void> deleteGroup(String groupId) {
        return Observable.empty();
    }

}
