package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import javax.inject.Inject;

import io.relayr.java.api.services.NotificationService;
import io.relayr.java.model.json.JsonListResponse;
import io.relayr.java.model.json.JsonRequest;
import io.relayr.java.model.json.JsonResponse;
import io.relayr.java.model.notif.Environment;
import io.relayr.java.model.notif.NotificationPublish;
import io.relayr.java.model.notif.NotificationSubscription;
import io.relayr.java.model.notif.NotificationTransport;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.Path;
import rx.Observable;

public class MockNotificationService implements NotificationService {

    private final MockBackend mMockBackend;

    @Inject
    public MockNotificationService(MockBackend mockBackend) {
        mMockBackend = mockBackend;
    }

    @Override public Observable<JsonListResponse<Environment>> getEnvironments(@Path("projectId") String projectId) {
        return null;
    }

    @Override
    public Observable<JsonResponse<Environment>> createEnvironment(@Body JsonRequest<Environment> environment) {
        return null;
    }

    @Override public Observable<JsonResponse<Environment>> getEnvironment(@Path("environmentId") String environmentId) {
        return null;
    }

    @Override
    public Observable<JsonResponse<Environment>> getEnvironment(@Path("environmentId") String environmentId, @Body JsonRequest<Environment> environment) {
        return null;
    }

    @Override public Observable<Response> deleteEnvironment(@Path("environmentId") String environmentId) {
        return null;
    }

    @Override
    public Observable<JsonListResponse<NotificationSubscription>> getAllSubscriptions(String environmentId, String userId) {
        return mMockBackend.createObservable(new TypeToken<JsonListResponse<NotificationSubscription>>() {
        }, MockBackend.NOTIF_SUBS);
    }

    @Override
    public Observable<JsonResponse<NotificationSubscription>> createSubscription(@Path("environmentId") String environmentId, @Body JsonRequest<NotificationSubscription> environment) {
        return null;
    }

    @Override
    public Observable<JsonResponse<NotificationSubscription>> getSubscription(@Path("environmentId") String environmentId, @Path("subscriptionId") String subscriptionId) {
        return null;
    }

    @Override
    public Observable<Response> deleteSubscription(@Path("environmentId") String environmentId, @Path("subscriptionId") String subscriptionId) {
        return null;
    }

    @Override
    public Observable<JsonResponse<String>> createTopic(@Path("environmentId") String environmentId, @Body JsonRequest<String> topic) {
        return null;
    }

    @Override public Observable<JsonListResponse<String>> getTopics(@Path("environmentId") String environmentId) {
        return null;
    }

    @Override
    public Observable<Response> deleteTopic(@Path("environmentId") String environmentId, @Path("topicId") String topic) {
        return null;
    }

    @Override
    public Observable<JsonResponse<NotificationTransport>> createTransport(@Path("environmentId") String environmentId, @Body JsonRequest<NotificationTransport> transport) {
        return null;
    }

    @Override
    public Observable<JsonListResponse<NotificationTransport>> getTransports(@Path("environmentId") String environmentId) {
        return null;
    }

    @Override
    public Observable<JsonResponse<NotificationTransport>> getTransport(@Path("environmentId") String environmentId, @Path("transportId") String transportId) {
        return null;
    }

    @Override
    public Observable<JsonResponse<NotificationTransport>> updateTransport(@Path("environmentId") String environmentId, @Path("transportId") String transportId, @Body JsonRequest<NotificationTransport> transport) {
        return null;
    }

    @Override
    public Observable<Response> deleteTransport(@Path("environmentId") String environmentId, @Path("transportId") String transportId) {
        return null;
    }

    @Override
    public Observable<Response> publish(@Path("environmentId") String environmentId, @Path("transportId") String transportId, @Body JsonRequest<NotificationPublish> publish) {
        return null;
    }

}
