package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import javax.inject.Inject;

import io.relayr.java.api.OauthApi;
import io.relayr.java.model.OauthToken;
import rx.Observable;

public class MockOauthApi implements OauthApi {

    private final MockBackend mMockBackend;

    @Inject
    public MockOauthApi(MockBackend mockBackend) {
        mMockBackend = mockBackend;
    }

    @Override
    public Observable<OauthToken> authoriseUser(String code, String clientId, String clientSecret,
                                                String grantType, String redirectUri, String scope) {
        return mMockBackend.createObservable(new TypeToken<OauthToken>() {}, MockBackend.AUTHORISE_USER);
    }
}
