package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import java.util.List;

import javax.inject.Inject;

import io.relayr.java.api.ProjectsApi;
import io.relayr.java.model.projects.App;
import io.relayr.java.model.projects.ExtendedApp;
import retrofit.http.Body;
import retrofit.http.Path;
import rx.Observable;
import rx.functions.Func1;

public class MockProjectsApi implements ProjectsApi {

    private final MockBackend mServer;

    @Inject
    public MockProjectsApi(MockBackend mockBackend) {
        mServer = mockBackend;
    }

    @Override
    public Observable<App> getAppInfo() {
        return mServer.createObservable(new TypeToken<App>() {
        }, MockBackend.APP_INFO);
    }

    @Override public Observable<List<App>> getAllApps() {
        return mServer.createObservable(new TypeToken<List<App>>() {
        }, MockBackend.APP_LIST);
    }

    @Override public Observable<ExtendedApp> createApp(final ExtendedApp app) {
        return mServer.createObservable(new TypeToken<List<ExtendedApp>>() {
        }, MockBackend.APP_EXTENDED).flatMap(new Func1<List<ExtendedApp>, Observable<ExtendedApp>>() {
            @Override public Observable<ExtendedApp> call(List<ExtendedApp> apps) {
                return Observable.just(apps.get(0));
            }
        });
    }

    @Override public Observable<ExtendedApp> updateApp(String appId) {
        return mServer.createObservable(new TypeToken<List<ExtendedApp>>() {
        }, MockBackend.APP_EXTENDED).flatMap(new Func1<List<ExtendedApp>, Observable<ExtendedApp>>() {
            @Override public Observable<ExtendedApp> call(List<ExtendedApp> apps) {
                return Observable.just(apps.get(0));
            }
        });
    }

    @Override public Observable<Void> deleteApp(String appId) {
        return Observable.empty();
    }

    @Override public Observable<ExtendedApp> getApp(String appId) {
        return mServer.createObservable(new TypeToken<List<ExtendedApp>>() {
        }, MockBackend.APP_EXTENDED).flatMap(new Func1<List<ExtendedApp>, Observable<ExtendedApp>>() {
            @Override public Observable<ExtendedApp> call(List<ExtendedApp> apps) {
                return Observable.just(apps.get(0));
            }
        });
    }

    @Override public Observable<List<App>> getPublisherApps(String publisherId) {
        return mServer.createObservable(new TypeToken<List<App>>() {
        }, MockBackend.APP_LIST);
    }

    @Override
    public Observable<List<ExtendedApp>> getPublisherExtendedApps(String publisherId) {
        return mServer.createObservable(new TypeToken<List<ExtendedApp>>() {
        }, MockBackend.APP_EXTENDED);
    }

    @Override public Observable<List<ExtendedApp>> getUserApps(String userId) {
        return mServer.createObservable(new TypeToken<List<ExtendedApp>>() {
        }, MockBackend.APP_EXTENDED);
    }

    @Override
    public Observable<ExtendedApp> updateUserApp(String userId, String appId, ExtendedApp app) {
        return mServer.createObservable(new TypeToken<List<ExtendedApp>>() {
        }, MockBackend.APP_EXTENDED).flatMap(new Func1<List<ExtendedApp>, Observable<ExtendedApp>>() {
            @Override public Observable<ExtendedApp> call(List<ExtendedApp> apps) {
                return Observable.just(apps.get(0));
            }
        });
    }

    @Override
    public Observable<ExtendedApp> getUserApp(String userId, String appId) {
        return mServer.createObservable(new TypeToken<ExtendedApp>() {
        }, MockBackend.APP_EXTENDED);
    }

    @Override
    public Observable<Void> deleteUserApp(String userId, String appId) {
        return Observable.empty();
    }

}
