package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import java.util.List;

import javax.inject.Inject;

import io.relayr.java.api.PublishersApi;
import io.relayr.java.model.Publisher;
import rx.Observable;
import rx.functions.Func1;

public class MockPublishersApi implements PublishersApi {

    private final MockBackend mServer;

    @Inject
    public MockPublishersApi(MockBackend mockBackend) {
        mServer = mockBackend;
    }

    @Override public Observable<List<Publisher>> getAllPublishers() {
        return mServer.createObservable(new TypeToken<List<Publisher>>() {
        }, MockBackend.PUBLISHERS);
    }

    @Override public Observable<List<Publisher>> getUserPublishers(String userId) {
        return mServer.createObservable(new TypeToken<List<Publisher>>() {
        }, MockBackend.PUBLISHERS);
    }

    @Override public Observable<Publisher> getPublisher(final String publisherId) {
        return mServer.createObservable(new TypeToken<List<Publisher>>() {
        }, MockBackend.PUBLISHERS)
                .flatMap(new Func1<List<Publisher>, Observable<Publisher>>() {
                    @Override public Observable<Publisher> call(List<Publisher> publishers) {
                        return Observable.just(publishers.get(0));
                    }
                });
    }

    @Override public Observable<Publisher> updatePublisher(Publisher publisher) {
        return mServer.createObservable(new TypeToken<List<Publisher>>() {
        }, MockBackend.PUBLISHERS)
                .flatMap(new Func1<List<Publisher>, Observable<Publisher>>() {
                    @Override public Observable<Publisher> call(List<Publisher> publishers) {
                        return Observable.just(publishers.get(0));
                    }
                });
    }

    @Override public Observable<Void> deletePublisher(String publisherId) {
        return Observable.empty();
    }

    @Override public Observable<Publisher> createPublisher(Publisher publisher) {
        return mServer.createObservable(new TypeToken<List<Publisher>>() {
        }, MockBackend.PUBLISHERS)
                .flatMap(new Func1<List<Publisher>, Observable<Publisher>>() {
                    @Override public Observable<Publisher> call(List<Publisher> publishers) {
                        return Observable.just(publishers.get(0));
                    }
                });
    }
}
