package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import javax.inject.Inject;

import io.relayr.java.api.services.RawDataService;
import io.relayr.java.model.action.Reading;
import io.relayr.java.model.json.JsonListResponse;
import io.relayr.java.model.raw.RawReading;
import rx.Observable;

public class MockRawDataService implements RawDataService {

    private final MockBackend mMockBackend;

    @Inject
    public MockRawDataService(MockBackend mockBackend) {
        mMockBackend = mockBackend;
    }

    @Override
    public Observable<JsonListResponse<RawReading>> getData(String deviceId,
                                                            String path,
                                                            String meaning,
                                                            String start,
                                                            String end) {

        return mMockBackend.createObservable(new TypeToken<JsonListResponse<RawReading>>() {
        }, MockBackend.HISTORY_RAW);
    }
}
