package io.relayr.java.api.mock;

import com.google.gson.reflect.TypeToken;

import java.util.List;

import javax.inject.Inject;

import io.relayr.java.api.RelayrApi;
import io.relayr.java.model.Transmitter;
import io.relayr.java.model.TransmitterDevice;
import rx.Observable;
import rx.Subscriber;

import static io.relayr.java.api.mock.MockBackend.USER_TRANSMITTER_DEVICES;
import static io.relayr.java.api.mock.MockBackend.USERS_TRANSMITTER;

public class MockRelayrApi implements RelayrApi {

    private final MockBackend backend;

    Observable emptyObservable = Observable.create(new Observable.OnSubscribe<Void>() {
        @Override
        public void call(Subscriber<? super Void> subscriber) {
            subscriber.onNext(null);
        }
    });

    @Inject public MockRelayrApi(MockBackend mockBackend) {
        backend = mockBackend;
    }

    @Override
    public Observable<Transmitter> registerTransmitter(Transmitter transmitter) {
        return Observable.just(transmitter);
    }

    @Override
    public Observable<Transmitter> getTransmitter(String transmitter) {
        return backend.createObservable(new TypeToken<Transmitter>() {
        }, USERS_TRANSMITTER);
    }

    @Override
    public Observable<Transmitter> updateTransmitter(String id, Transmitter transmitter) {
        return Observable.just(transmitter);
    }

    @Override
    public Observable<Void> deleteTransmitter(String transmitterId) {
        return emptyObservable;
    }

    @Override
    public Observable<Void> deleteWunderBar(String transmitterId) {
        return emptyObservable;
    }

    @Override
    public Observable<List<TransmitterDevice>> getTransmitterDevices(String transmitter) {
        return backend.createObservable(new TypeToken<List<TransmitterDevice>>() {
        }, USER_TRANSMITTER_DEVICES);
    }
}
