package io.relayr.java.api.mock;

import java.util.List;

import javax.inject.Inject;

import io.relayr.java.api.RuleTemplateApi;
import io.relayr.java.model.rules.AppliedTemplate;
import io.relayr.java.model.rules.Template;
import io.relayr.java.model.rules.TemplateInfo;
import io.relayr.java.model.rules.TemplateParameters;
import retrofit.client.Response;
import rx.Observable;

public class MockRuleTemplateApi implements RuleTemplateApi {

    private static final String TAG = "MockRuleTemplateApi";
    private final MockBackend mMockBackend;

    @Inject
    public MockRuleTemplateApi(MockBackend mockBackend) {
        mMockBackend = mockBackend;
    }

    @Override public Observable<List<TemplateInfo>> getTemplates(String projectId) {
        return null;
    }

    @Override
    public Observable<TemplateInfo> getTemplate(String projectId, String templateId) {
        return null;
    }

    @Override
    public Observable<List<Template>> getTemplateVersions(String projectId, String templateId) {
        return null;
    }

    @Override
    public Observable<Template> getTemplateVersion(String projectId, String templateId, String templateVersionId) {
        return null;
    }

    @Override
    public Observable<AppliedTemplate> applyTemplate(TemplateParameters template, String projectId, String templateId, String templateVersionId) {
        return null;
    }

    @Override
    public Observable<List<AppliedTemplate>> getAppliedTemplates(String userId) {
        return null;
    }

    @Override
    public Observable<AppliedTemplate> getAppliedTemplate(String userId, String installationId) {
        return null;
    }

    @Override
    public Observable<Response> deleteAppliedTemplate(String userId, String installationId) {
        return null;
    }

    @Override
    public Observable<AppliedTemplate> updateAppliedTemplate(Object template, String userId, String installationId) {
        return null;
    }
}
