package io.relayr.java.api.services;

import java.util.concurrent.TimeUnit;

import io.relayr.java.api.helpers.Aggregates;
import io.relayr.java.model.aggregated.AggregatedData;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;
import rx.Observable;

/**
 * This class incorporates a wrapped version of the relayr histyory aggregate API calls.
 * Each device's readings are persisted in DB and can be viewed through AggregatedDataService.
 * At the moment only primitive readings (boolean, number, string) are persisted.
 */
public interface AggregatedDataService {
    /**
     * Return aggregated history data
     * Valid time units are: {@link TimeUnit#SECONDS},{@link TimeUnit#MINUTES}, {@link TimeUnit#HOURS}, {@link TimeUnit#DAYS}
     * Warning: Sample is not supported with complex data, but only with Integer, Number and Boolean values
     * @param deviceId   -  unique device identifier - required
     * @param path       - device reading path {@link io.relayr.java.model.action.Reading#path} - optional
     * @param meaning    - device reading meaning {@link io.relayr.java.model.action.Reading#meaning} - optional
     * @param start      - 2016-11-09T10:21:00.000Z
     * @param end        - 2016-11-09T10:22:00.000Z
     * @param interval   - {@link Aggregates.Interval}
     * @param aggregates - {@link Aggregates.Aggregate}
     */
    @GET("/devices/{id}/aggregated-readings")
    Observable<AggregatedData> getData(@Path("id") String deviceId,
                                       @Query("path") String path,
                                       @Query("meaning") String meaning,
                                       @Query("start") String start,
                                       @Query("end") String end,
                                       @Query("interval") String interval,
                                       @Query("aggregates") String aggregates);

}
