package io.relayr.java.api.services;

import io.relayr.java.model.json.JsonListResponse;
import io.relayr.java.model.json.JsonRequest;
import io.relayr.java.model.json.JsonResponse;
import io.relayr.java.model.notif.Environment;
import io.relayr.java.model.notif.NotificationPublish;
import io.relayr.java.model.notif.NotificationSubscription;
import io.relayr.java.model.notif.NotificationTransport;
import retrofit.client.Response;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.GET;
import retrofit.http.PATCH;
import retrofit.http.POST;
import retrofit.http.Path;
import retrofit.http.Query;
import rx.Observable;

public interface NotificationService {

    //Environments
    @GET("/notification-environments")
    Observable<JsonListResponse<Environment>> getEnvironments(
            @Query("projectId") String projectId);

    @POST("/notification-environments")
    Observable<JsonResponse<Environment>> createEnvironment(
            @Body JsonRequest<Environment> environment);

    @GET("/notification-environments/{environmentId}")
    Observable<JsonResponse<Environment>> getEnvironment(
            @Path("environmentId") String environmentId);

    @PATCH("/notification-environments/{environmentId}")
    Observable<JsonResponse<Environment>> getEnvironment(
            @Path("environmentId") String environmentId,
            @Body JsonRequest<Environment> environment);

    @DELETE("/notification-environments/{environmentId}")
    Observable<Response> deleteEnvironment(
            @Path("environmentId") String environmentId);

    //Subscriptions
    @GET("/notification-environments/{environmentId}/subscriptions")
    Observable<JsonListResponse<NotificationSubscription>> getAllSubscriptions(
            @Path("environmentId") String environmentId,
            @Query("userId") String userId);

    @POST("/notification-environments/{environmentId}/subscriptions")
    Observable<JsonResponse<NotificationSubscription>> createSubscription(
            @Path("environmentId") String environmentId,
            @Body JsonRequest<NotificationSubscription> environment);

    @GET("/notification-environments/{environmentId}/subscriptions/{subscriptionId}")
    Observable<JsonResponse<NotificationSubscription>> getSubscription(
            @Path("environmentId") String environmentId,
            @Path("subscriptionId") String subscriptionId);

    @DELETE("/notification-environments/{environmentId}/subscriptions/{subscriptionId}")
    Observable<Response> deleteSubscription(
            @Path("environmentId") String environmentId,
            @Path("subscriptionId") String subscriptionId);

    //Topics
    @POST("/notification-environments/{environmentId}/topics")
    Observable<JsonResponse<String>> createTopic(
            @Path("environmentId") String environmentId,
            @Body JsonRequest<String> topic);

    @GET("/notification-environments/{environmentId}/topics")
    Observable<JsonListResponse<String>> getTopics(
            @Path("environmentId") String environmentId);

    @DELETE("/notification-environments/{environmentId}/topics/{topicId}")
    Observable<Response> deleteTopic(
            @Path("environmentId") String environmentId,
            @Path("topicId") String topic);

    //Transports
    @POST("/notification-environments/{environmentId}/transports")
    Observable<JsonResponse<NotificationTransport>> createTransport(
            @Path("environmentId") String environmentId,
            @Body JsonRequest<NotificationTransport> transport);


    @GET("/notification-environments/{environmentId}/transports")
    Observable<JsonListResponse<NotificationTransport>> getTransports(
            @Path("environmentId") String environmentId);


    @GET("/notification-environments/{environmentId}/transports/{transportId}")
    Observable<JsonResponse<NotificationTransport>> getTransport(
            @Path("environmentId") String environmentId,
            @Path("transportId") String transportId);

    @PATCH("/notification-environments/{environmentId}/transports/{transportId}")
    Observable<JsonResponse<NotificationTransport>> updateTransport(
            @Path("environmentId") String environmentId,
            @Path("transportId") String transportId,
            @Body JsonRequest<NotificationTransport> transport);

    @DELETE("/notification-environments/{environmentId}/transports/{transportId}")
    Observable<Response> deleteTransport(
            @Path("environmentId") String environmentId,
            @Path("transportId") String transportId);

    //Publish
    @POST("/notification-environments/{environmentId}/publish")
    Observable<Response> publish(
            @Path("environmentId") String environmentId,
            @Path("transportId") String transportId,
            @Body JsonRequest<NotificationPublish> publish);
}
