package io.relayr.java.api.services;

import io.relayr.java.model.json.JsonListResponse;
import io.relayr.java.model.raw.RawReading;
import retrofit.http.GET;
import retrofit.http.Path;
import retrofit.http.Query;
import rx.Observable;

/**
 * This class incorporates a wrapped version of the relayr Raw Data Service API calls.
 * Each device's readings are persisted in DB and can be viewed through this service.
 */
public interface RawDataService {

    /**
     * Return raw historical data
     * @param deviceId -  unique device identifier - required
     * @param path     - device reading path {@link io.relayr.java.model.action.Reading#path} - optional
     * @param meaning  - device reading meaning {@link io.relayr.java.model.action.Reading#meaning} - optional
     * @param start    - 2016-11-09T10:21:00.000Z
     * @param end      - 2016-11-09T10:22:00.000Z
     */
    @GET("/devices/{id}/raw-readings")
    Observable<JsonListResponse<RawReading>> getData(@Path("id") String deviceId,
                                                     @Query("path") String path,
                                                     @Query("meaning") String meaning,
                                                     @Query("start") String start,
                                                     @Query("end") String end);

}
