package io.relayr.java.model;

import java.io.Serializable;

/** Use to add new device to Relayr platform. For example when creating a prototype. */
public class CreateDevice implements Serializable {

    private String name;
    private String description;
    private final String owner;
    private String model;
    private String firmwareVersion;
    private String externalId;
    private String transmitterId;
    private String integrationType;

    /** Default simple constructor for prototype creation */
    public CreateDevice(String name, String userId) {
        this.name = name;
        this.owner = userId;
        this.integrationType = "relayr";
    }

    /** Default constructor for prototype creation */
    public CreateDevice(String name, String modelId, String userId, String externalId, String firmware) {
        this(name, userId);
        this.model = modelId;
        this.externalId = externalId;
        this.firmwareVersion = firmware;
    }

    /** Default constructor for prototype creation */
    public CreateDevice(String name, String description, String modelId, String userId, String externalId, String firmware) {
        this(name, modelId, userId, externalId, firmware);
        this.description = description;
    }

    public CreateDevice(String name, String description, String modelId, String userId, String externalId, String firmware, String accountType) {
        this(name, description, modelId, userId, externalId, firmware);
        this.integrationType = accountType;
    }

    public String getName() {
        return name;
    }

    public void setTransmitterId(String transmitterId) {
        this.transmitterId = transmitterId;
    }

    public void setIntegrationType(String integrationType) {
        this.integrationType = integrationType;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setFirmware(String firmware) {
        this.firmwareVersion = firmware;
    }

    public void setModel(String model) {
        this.model = model;
    }
}
