package io.relayr.java.model;

import java.io.Serializable;

/**
 * A Publisher is a basic entity in the relayr platform.
 * Each user can choose to have the option to publish apps on the relayr platform
 * and they are then assigned a publisherId.
 */
public class Publisher implements Serializable {

    private String id;
    private String name;
    private String owner;

    public Publisher(String id, String name, String owner) {
        this.id = id;
        this.name = name;
        this.owner = owner;
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getOwner() {
        return owner;
    }

    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Publisher publisher = (Publisher) o;

        return id.equals(publisher.id);

    }

    @Override public int hashCode() {
        return id.hashCode();
    }

    @Override public String toString() {
        return "Publisher{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", owner='" + owner + '\'' +
                '}';
    }
}
