package io.relayr.java.model;

import java.io.Serializable;

import io.relayr.java.RelayrJavaSdk;
import rx.Observable;

/**
 * The transmitter device object holds the same information as the {@link Device}
 * The difference is that the io.relayr.java.model attribute in the former is an ID rather than an object.
 */
public class TransmitterDevice extends Transmitter implements Serializable {

    private final String modelId;

    public TransmitterDevice(String id, String secret, String owner, String name, String model) {
        super(id, secret, owner, name);
        this.modelId = model;
    }

    public String getModelId() {
        return modelId;
    }

    @Override
    public int hashCode() {
        return getId().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof TransmitterDevice && ((TransmitterDevice) o).getId().equals(getId()) ||
                o instanceof Device && ((Device) o).getId().equals(getId());
    }

    public Observable<io.relayr.java.model.action.Reading> subscribeToCloudReadings() {
        return RelayrJavaSdk.getWebSocketClient().subscribe(getId());
    }

    public void unSubscribeToCloudReadings() {
        RelayrJavaSdk.getWebSocketClient().unSubscribe(getId());
    }

    /** Sends a command to the this device */
    public Observable<Void> sendCommand(io.relayr.java.model.action.Command command) {
        return command.send(getId());
    }

    @Override public String toString() {
        return "TransmitterDevice{" +
                ", modelId='" + modelId + '\'' +
                "} " + super.toString();
    }
}
