package io.relayr.java.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import io.relayr.java.ble.BleDeviceType;
import io.relayr.java.model.account.AccountType;

@Deprecated
public class WunderBar implements Serializable {

    public final AccountType type;
    public final Transmitter masterModule;
    public List<TransmitterDevice> wbDevices = new ArrayList<>();

    public WunderBar(Transmitter masterModule, TransmitterDevice gyroscope,
                     TransmitterDevice light, TransmitterDevice microphone,
                     TransmitterDevice thermometer, TransmitterDevice infrared,
                     TransmitterDevice bridge) {
        this.type = AccountType.WUNDERBAR_1;
        this.masterModule = masterModule;
        this.wbDevices = Arrays.asList(gyroscope, light, microphone, thermometer, infrared, bridge);
    }

    public WunderBar(Transmitter masterModule, List<TransmitterDevice> devices, AccountType type) {
        this.type = type == null ? AccountType.WUNDERBAR_1 : type;
        this.masterModule = masterModule;
        wbDevices.addAll(devices);
    }

    //WB2
    public WunderBar(Transmitter masterModule) {
        this(masterModule, new ArrayList<TransmitterDevice>(), AccountType.WUNDERBAR_2);
    }

    public static WunderBar from(Transmitter masterModule, List<TransmitterDevice> devices) {
        return new WunderBar(masterModule, devices, masterModule.getAccountType());
    }

    public TransmitterDevice getDevice(BleDeviceType type) {
        for (TransmitterDevice device : wbDevices) {
            BleDeviceType bleDeviceType = BleDeviceType.fromModel(device.getModelId());
            if (bleDeviceType == type) return device;
        }

        return null;
    }

    public TransmitterDevice getDevice(String modelId) {
        for (TransmitterDevice device : wbDevices)
            if (device.getModelId().equals(modelId)) return device;

        return null;
    }

    @Override public String toString() {
        return "WunderBar{" +
                "type=" + type +
                ", masterModule=" + masterModule.toString() +
                ", wbDevices=" + wbDevices.toString() +
                '}';
    }
}
