package io.relayr.java.model.action;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

import io.relayr.java.RelayrJavaSdk;
import io.relayr.java.model.models.DeviceModel;
import io.relayr.java.model.models.transport.DeviceConfiguration;
import rx.Observable;

/**
 * Defines configuration parameters currently on device. Defined with {@link DeviceConfiguration}
 * in {@link DeviceModel}
 */
public class Configuration extends Action implements Serializable {

    /**
     * @param path          identifies the component to which the configuration should be sent {@link DeviceConfiguration#getPath()}
     * @param configuration defined in device io.relayr.java.model {@link DeviceConfiguration#getName()}
     * @param value         type of value object is defined in device io.relayr.java.model with {@link DeviceConfiguration#getValueSchema()}
     */
    public Configuration(String path, String configuration, Object value) {
        this.path = path;
        this.value = value;
        this.name = configuration;
    }

    @Override public Observable<Void> send(String deviceId) {
        if (name == null) throwIfNull("Configuration name");
        if (value == null) throwIfNull("Value");

        if (!mValidated) throwNotValidated();

        return RelayrJavaSdk.getDeviceApi()
                .sendConfiguration(deviceId, this)
                .timeout(7, TimeUnit.SECONDS);
    }

    @Override public String toString() {
        return "Configuration{" + super.toString() + "}";
    }
}
