package io.relayr.java.model.aggregated;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.TimeZone;

import io.relayr.java.helper.observer.TimeZoneUtil;

public class AggregatedReading implements Serializable {

    private String timestamp;
    private double count;
    private double avg;
    private double min;
    private double max;
    private double totalCount;
    private double boolCount;
    private double numCount;
    private double stringCount;
    private double latLongCount;
    private double xyzCount;
    private double lengthAvg;

    private HashMap<String, Double> stringValues;
    private AggregatedBooleans boolValues;
    private AggregatedLatLon latLonAvg;
    private AggregatedXYZ xyzAvg;

    /**
     * Returns ISO timestamp in UTC timezone
     */
    public String getUtcIsoTs() {
        return timestamp;
    }

    /**
     * Returns timestamp in local timezone
     */
    public long getLocaleTs() {
        return TimeZoneUtil.getLocaleTs(timestamp);
    }

    /**
     * Returns timestamp in UTC timezone
     */
    public long getUtcTs() {
        return TimeZoneUtil.getUtcTs(timestamp);
    }

    public double getCount() {
        return count;
    }

    public double getAvg() {
        return avg;
    }

    public double getMin() {
        return min;
    }

    public double getMax() {
        return max;
    }

    public double getTotalCount() {
        return totalCount;
    }

    public double getBoolCount() {
        return boolCount;
    }

    public double getNumCount() {
        return numCount;
    }

    public double getStringCount() {
        return stringCount;
    }

    public double getLatLongCount() {
        return latLongCount;
    }

    public double getXyzCount() {
        return xyzCount;
    }

    public double getLengthAvg() {
        return lengthAvg;
    }

    public HashMap<String, Double> getStringValues() {
        return stringValues;
    }

    public AggregatedBooleans getBoolValues() {
        return boolValues;
    }

    public AggregatedLatLon getLatLonAvg() {
        return latLonAvg;
    }

    public AggregatedXYZ getXyzAvg() {
        return xyzAvg;
    }
}
