package io.relayr.java.model.channel;

import java.io.Serializable;

public class ChannelDefinition implements Serializable {

    private String deviceId;
    private String transport;

    /**
     * Creates channel definition object with default {@link ChannelTransport#MQTT} transport type
     * @param deviceId - device identificator
     */
    public ChannelDefinition(String deviceId) {
        this(deviceId, ChannelTransport.MQTT);
    }

    /**
     * Creates channel definition object.
     * @param deviceId  - device identificator
     * @param transport - {@link ChannelTransport#MQTT} or {@link ChannelTransport#HTTP}
     */
    public ChannelDefinition(String deviceId, ChannelTransport transport) {
        if (deviceId == null) throw new NullPointerException("Device ID can't be NULL.");
        if (transport == null) throw new NullPointerException("Transport type can't be NULL.");

        this.deviceId = deviceId;
        this.transport = transport.name().toLowerCase();
    }
}
