package io.relayr.java.model.groups;

import com.google.gson.annotations.SerializedName;

import java.io.Serializable;

import io.relayr.java.model.Device;

class GroupDevice implements Serializable {

    private static final long serialVersionUID = 1L;

    private final String id;
    private final String name;
    private final String modelId;
    private final String owner;
    private final String firmwareVersion;
    private final String secret;
    private final String externalId;
    private final int position;
    @SerializedName("public") private final boolean isPublic;
    @SerializedName("integrationType") private final String accountType;

    public GroupDevice(String accountType, boolean isPublic, String externalId, String secret,
                       String firmwareVersion, String owner, String modelId, String name, String id, int position) {
        this.id = id;
        this.name = name;
        this.owner = owner;
        this.accountType = accountType;
        this.isPublic = isPublic;
        this.externalId = externalId;
        this.secret = secret;
        this.firmwareVersion = firmwareVersion;
        this.modelId = modelId;
        this.position = position;
    }

    public Device toDevice() {
        return new Device(id, modelId, name, "", owner, firmwareVersion, externalId, isPublic, accountType);
    }

    public int getPosition() {
        return position;
    }
}
