package io.relayr.java.model.json;

import com.google.gson.Gson;

import java.io.Serializable;

public class JsonRequest<T> implements Serializable {
    private Object data;

    public JsonRequest(T data) {
        this.data = data;
    }

    public T getData(T type) {
        if (data == null) return null;
        return new Gson().fromJson(data.toString(), (Class<T>) type);
    }
}
