package io.relayr.java.model.models.schema;

import java.util.List;

public class ArraySchema extends ValueSchema {

    public ArraySchema(ValueSchema schema) {
        super(schema);
        items = schema.items;
        maxItems = schema.maxItems;
        minItems = schema.minItems;
        uniqueItems = schema.uniqueItems;
        additionalItems = schema.additionalItems;
    }

    /** Items of this array MUST be objects, and each of these objects MUST be a valid JSON Schema. */
    public Object getItems() {
        return items;
    }

    /** Items of this array MUST be objects, and each of these objects MUST be a valid JSON Schema. */
    public List<Object> getItemsList() {
        try {
            if (items instanceof List)
                return (List<Object>) items;
        } catch (Exception e) {
            return null;
        }

        return null;
    }

    /** If defined this integer MUST be greater than, or equal to, 0. */
    public Integer getMaxItems() {
        return maxItems;
    }

    /** If defined this integer MUST be greater than, or equal to, 0. */
    public Integer getMinItems() {
        return minItems;
    }

    public boolean areItemsUnique() {
        return uniqueItems;
    }

    /** @return true if there can be any additional items in {@link #items} */
    public boolean containsAdditionalItems() {
        if (additionalItems == null) return false;

        if (additionalItems instanceof Boolean)
            return (boolean) additionalItems;

        return true;
    }

    @Override public boolean validate(Object value) {
        return validateNull(value);
    }
}
