package io.relayr.java.model.models.schema;

public class IntegerSchema extends NumberSchema {

    public IntegerSchema(ValueSchema schema) {
        super(schema);
    }

    /** @return minimum value. */
    @Override
    public Integer getMin() { return minimum == null ? null : minimum.intValue(); }

    /** @return maximum value. */
    @Override
    public Integer getMax() {
        return maximum == null ? null : maximum.intValue();
    }


    @Override public boolean validate(Object value) {
        if (!super.validate(value)) return false;
        if (!(value instanceof Integer)) return false;

        return true;
    }
}
