package io.relayr.java.model.notif;

import java.util.HashSet;
import java.util.Set;

import io.relayr.java.helper.Validator;

public class Environment {

    private String id;
    private String projectId;
    private String name;
    private Set<NotificationTransport> transports = new HashSet<>();
    private Set<String> topics = new HashSet<>();

    public Environment(String projectId, String name, Set<NotificationTransport> transports, Set<String> topics) {
        Validator.requireNotNullNotEmpty(projectId, "ProjectId can't be null or empty string.");
        Validator.requireValidUuid(projectId, "ProjectId must be a valid UUID.");

        Validator.requireNotNullNotEmpty(name, "Environment name can't be null or empty string.");

        for (String topic : topics) {
            Validator.requireNotNullNotEmpty(topic, "Topic can't be null or empty.");
            Validator.requireAscii(topic, "Topic must be a st of ascii characters.");
        }
        this.name = name;
        this.topics = topics;

        if (transports != null) this.transports = transports;
    }

    public String getId() {
        return id;
    }

    public String getProjectId() {
        return projectId;
    }

    public String getName() {
        return name;
    }

    public Set<NotificationTransport> getTransports() {
        return transports;
    }

    public Set<String> getTopics() {
        return topics;
    }
}
