package io.relayr.java.model.notif;

import com.google.common.base.Strings;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import io.relayr.java.helper.Validator;

public class NotificationPublish {

    private String title;
    private String message;
    private String topic;
    private Set<String> transports = new HashSet<>();
    private Set<String> deviceIds = new HashSet<>();

    private Object payload;

    public NotificationPublish(String title, String message, String topic, Set<String> transports, Set<String> deviceIds, Object payload) {
        Validator.requireNotNullNotEmpty(topic, "Topic can't be null or empty string");
        Validator.requireNotNullNotEmpty(deviceIds, "Can't publish without specified deviceIds");

        if (Strings.isNullOrEmpty(title))
            Logger.getLogger("NotificationPublish").log(Level.WARNING, "Provide a title to summarize your message.");

        this.title = title;
        this.message = message;
        this.topic = topic;
        this.deviceIds = deviceIds;
        this.payload = payload;

        if (transports != null) this.transports = transports;
    }
}
