package io.relayr.java.model.notif;

import io.relayr.java.helper.Validator;

public class NotificationSubscription {

    private String id;
    private String transport;
    private String topic;
    private String target;
    private String deviceId;

    public NotificationSubscription(String transport, String topic, String target, String deviceId) {
        Validator.requireNotNullNotEmpty(transport, "Transport can't be null or empty string");
        Validator.requireValidUuid(transport, "Transport is not a valid UUID");

        Validator.requireNotNullNotEmpty(topic, "Topic can't be null or empty string");
        Validator.requireNotNullNotEmpty(target, "Target can't be null or empty string");

        Validator.requireNotNullNotEmpty(deviceId, "Device ID can't be null or empty");
        Validator.requireValidUuid(deviceId, "Device ID is not a valid UUID");

        this.transport = transport;
        this.topic = topic;
        this.target = target;
        this.deviceId = deviceId;
    }

    public String getId() {
        return id;
    }

    public String getTransport() {
        return transport;
    }

    public String getTopic() {
        return topic;
    }

    public String getTarget() {
        return target;
    }

    public String getDeviceId() {
        return deviceId;
    }
}
