package io.relayr.java.model.notif;

import io.relayr.java.helper.Validator;

public class NotificationTransport {

    enum TransportProvider {
        GCM("gcm"), APNS("apns"), SMS("sms");

        private final String name;

        TransportProvider(String name) {
            this.name = name;
        }

        public String getName() {
            return name;
        }
    }

    private String id;
    private String provider;

    public NotificationTransport(TransportProvider provider) {
        Validator.requireNotNull(provider, "Provider can't be null.");

        this.provider = provider.name;
    }

    public String getProvider() {
        return provider;
    }

    public String getId() {
        return id;
    }
}
