package io.relayr.java.model.notifications;

import com.google.gson.annotations.SerializedName;

public class Notification {

    private String token;
    private String service;
    @SerializedName("id") private String notificationId;

    public static Notification create(String token) {
        return new Notification(token, NotificationService.GCM);
    }

    public Notification(String token, NotificationService service) {
        this(token, null, service);
    }

    public Notification(String token, String id, NotificationService service) {
        this.token = token;
        this.service = service.getName();
        this.notificationId = id;
    }

    public String getToken() {
        return token;
    }

    public NotificationService getService() {
        return NotificationService.getByName(service);
    }

    public String getId() {
        return notificationId;
    }
}
