package io.relayr.java.model.notifications;

public enum NotificationService {

    GCM("gcm"), APNS("apns");

    private final String name;

    NotificationService(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static NotificationService getByName(String service) {
        for (NotificationService val : values())
            if (val.getName().equals(service)) return val;
        return null;
    }
}
