package io.relayr.java.model.notifications;

import java.util.List;

public class NotificationUser {

    private String id;
    private String token;
    private String service;
    private List<NotificationSub> subscriptions;

    public static NotificationUser create(String token) {
        return new NotificationUser(token, NotificationService.GCM);
    }

    public NotificationUser(String token, NotificationService service) {
        this(token, null, service);
    }

    public NotificationUser(String token, String id, NotificationService service) {
        this.token = token;
        this.service = service.getName();
        this.id = id;
    }

    public String getToken() {
        return token;
    }

    public NotificationService getService() {
        return NotificationService.getByName(service);
    }

    public String getId() {
        return id;
    }

    public List<NotificationSub> getSubscriptions() {
        return subscriptions;
    }
}
