package io.relayr.java.model.projects;

import java.io.Serializable;

/**
 * An app is a basic entity in the relayr platform. The relayr platform relates to apps in two
 * manners: Publisher Apps and User Apps.
 * Publisher apps are apps which are purchasable on an app store and are owned by a publisher.
 * User apps are apps which have been approved to the data of an end user. This approval has been
 * granted by the user.
 * relayr deploys the OAuth 2.0 standard for third party applications authorization.
 * To read about this component please visit our
 * @see <a href="https://developer.relayr.io/documents/Authorization/OAuthAndRelayr">Authorization
 * reference</a>
 */
public class App implements Serializable {

    protected final String id;
    protected final String name;
    protected final String description;

    /**
     * Construction Method for an app
     * @param id          the relayr assigned id for the app instance
     * @param name        The name of this app
     * @param description a brief description of the app
     */
    public App(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    /** Represents the relayr Application ID. Generated when creating an app on the relayr developer dashboard. */
    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    @Override public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        App app = (App) o;

        return id.equals(app.id);

    }

    @Override public int hashCode() {
        return id.hashCode();
    }

    @Override public String toString() {
        return "App{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", description='" + description + '\'' +
                '}';
    }
}
